/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.contenttypes.XMLContentTypeHandler;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.xml.XML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractContentTypeLoader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(AbstractContentTypeLoader.class);

    public void run(final ScriptContext ctx) {
        new KernelExcursion(){

            protected void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                AbstractContentTypeLoader.this.createTypes(ctx);
            }
        }.run();
    }

    private void createTypes(ScriptContext ctx) {
        XMLContentTypeHandler handler = new XMLContentTypeHandler();
        String[] contentTypes = this.getTypes();
        for (int i = 0; i < contentTypes.length; ++i) {
            XML.parseResource((String)contentTypes[i], (DefaultHandler)handler);
        }
        List types = handler.getContentTypes();
        Session ssn = ctx.getSession();
        DataCollection sections = ssn.retrieve("com.arsdigita.cms.ContentSection");
        while (sections.next()) {
            ContentSection section = (ContentSection)DomainObjectFactory.newInstance((DataObject)sections.getDataObject());
            if (!this.isLoadableInto(section)) continue;
            LifecycleDefinitionCollection ldc = section.getLifecycleDefinitions();
            LifecycleDefinition ld = null;
            if (ldc.next()) {
                ld = ldc.getLifecycleDefinition();
                ldc.close();
            }
            WorkflowTemplate wf = section.getDefaultWorkflowTemplate();
            for (ContentType type : types) {
                section.addContentType(type);
                this.prepareSection(section, type, ld, wf);
            }
        }
    }

    protected void prepareSection(ContentSection section, ContentType type, LifecycleDefinition ld, WorkflowTemplate wf) {
        ContentTypeLifecycleDefinition.updateLifecycleDefinition(section, type, ld);
        ContentTypeWorkflowTemplate.updateWorkflowTemplate(section, type, wf);
    }

    protected abstract String[] getTypes();

    private boolean isLoadableInto(ContentSection section) {
        if (section == null) {
            throw new NullPointerException("section");
        }
        if (this.getContentSections().size() > 0) {
            return this.getContentSections().contains(section.getName());
        }
        return ContentSection.getConfig().getDefaultContentSection().equals(section.getName());
    }

    protected List getContentSections() {
        return Collections.EMPTY_LIST;
    }

    protected Template setDefaultTemplate(String name, String label, InputStream templateIs, ContentSection section, ContentType type, LifecycleDefinition ld, WorkflowTemplate wf) {
        Template template = new Template();
        template.setName(name);
        template.setLabel(label);
        template.setContentSection(section);
        template.setParent((ACSObject)section.getTemplatesFolder());
        Assert.isTrue((templateIs != null ? 1 : 0) != 0, (String)"Template not found");
        BufferedReader input = new BufferedReader(new InputStreamReader(templateIs));
        StringBuffer body = new StringBuffer();
        try {
            String line;
            while ((line = input.readLine()) != null) {
                body.append(line);
                body.append("\n");
            }
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException("Template cannot be read", (Throwable)ioe);
        }
        template.setText(body.toString());
        TemplateManagerFactory.getInstance().addTemplate(section, type, template, "public");
        template.publish(ld, new Date());
        return template;
    }
}

