/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.contenttypes.ContentGroupAssociation;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class ContentGroup
extends ContentItem {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.ContentGroup";
    public static final String ITEM_ASSOCIATIONS = "itemAssociations";

    public ContentGroup() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ContentGroup(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentGroup(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ContentGroup(DataObject obj) {
        super(obj);
    }

    public ContentGroup(String type) {
        super(type);
    }

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void addContentItem(ContentItem item) {
        ContentGroupAssociation assoc = this.getItemAssociation(item);
        if (assoc == null) {
            assoc = new ContentGroupAssociation(item, this);
            assoc.setName(item.getName() + this.getID());
            assoc.setSortKey(new Integer(this.getMaxSortKey() + 1));
            assoc.setMaster(this.getMaster());
            assoc.save();
            this.add(ITEM_ASSOCIATIONS, (DomainObject)assoc);
        }
    }

    public void removeContentItem(ContentItem item) {
        ContentGroupAssociation assoc = this.getItemAssociation(item);
        if (assoc != null) {
            assoc.delete();
        }
    }

    public void clearContentItems() {
        ItemCollection collection = this.getContentGroupAssociations();
        while (collection.next()) {
            collection.getContentItem().delete();
        }
    }

    private DataCollection getAssociationDataCollection(boolean addOrder) {
        DataCollection collection = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.ContentGroupAssociation");
        collection.addEqualsFilter("contentGroup.id", (Object)this.getID());
        collection.alias("isDeleted", "isDeleted");
        collection.addEqualsFilter("isDeleted", (Object)Boolean.FALSE);
        if (addOrder) {
            collection.addOrder("sortKey");
        }
        return collection;
    }

    private ContentGroupAssociation getItemAssociation(ContentItem item) {
        DataCollection collection = this.getAssociationDataCollection(false);
        collection.addEqualsFilter("contentItem.id", (Object)item.getID());
        if (collection.next()) {
            DataObject object = collection.getDataObject();
            collection.close();
            return new ContentGroupAssociation(object);
        }
        return null;
    }

    public ItemCollection getContentItems() {
        DataCollection collection = this.getAssociationDataCollection(true);
        collection.addEqualsFilter("contentItem.isDeleted", (Object)Boolean.FALSE);
        DataQueryDataCollectionAdapter query = new DataQueryDataCollectionAdapter((DataQuery)collection, "contentItem");
        return new ItemCollection((DataCollection)query);
    }

    public ItemCollection getContentGroupAssociations() {
        DataCollection collection = this.getAssociationDataCollection(true);
        return new ItemCollection(collection);
    }

    public void swapWithNext(ContentItem item) {
        ContentGroupAssociation assoc = this.getItemAssociation(item);
        if (assoc != null) {
            assoc.swapWithNext();
        }
    }

    public void swapWithPrevious(ContentItem item) {
        ContentGroupAssociation assoc = this.getItemAssociation(item);
        if (assoc != null) {
            assoc.swapWithPrevious();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxSortKey() {
        Integer sortKey = null;
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.maxItemSortKeyInGroupWithDeleted");
        query.setParameter("groupID", (Object)this.getID());
        try {
            if (query.next()) {
                sortKey = (Integer)query.get("sortKey");
            }
        }
        finally {
            query.close();
        }
        if (sortKey != null) {
            return sortKey;
        }
        return -1;
    }
}

