/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.SimpleDomainObjectTraversalAdapter;
import com.arsdigita.persistence.metadata.Property;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContentItemTraversalAdapter
extends SimpleDomainObjectTraversalAdapter {
    private static final Logger s_log = Logger.getLogger(ContentItemTraversalAdapter.class);
    private static final Map s_assetAdapters = new HashMap();

    public static void registerAssetAdapter(String path, DomainObjectTraversalAdapter adapter, String context) {
        HashMap<String, DomainObjectTraversalAdapter> adapters;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Registering asset adapter " + path + " adapter " + adapter.getClass() + " in context " + context));
        }
        if ((adapters = (HashMap<String, DomainObjectTraversalAdapter>)s_assetAdapters.get(context)) == null) {
            adapters = new HashMap<String, DomainObjectTraversalAdapter>();
            s_assetAdapters.put(context, adapters);
        }
        adapters.put(path, adapter);
    }

    public ContentItemTraversalAdapter() {
    }

    public ContentItemTraversalAdapter(SimpleDomainObjectTraversalAdapter adapter) {
        super(adapter);
    }

    public boolean processProperty(DomainObject obj, String path, Property prop, String context) {
        String prefix;
        int offset;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Process property " + path + " in context " + context));
        }
        if ((offset = path.indexOf("/", (prefix = "/object/").length())) == -1) {
            String base = path.substring(prefix.length());
            Map adapters = (Map)s_assetAdapters.get(context);
            if (adapters != null && adapters.containsKey(base)) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Following asset");
                }
                return true;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Root delegate to primary adapter " + base));
            }
            return super.processProperty(obj, path, prop, context);
        }
        String base = path.substring(prefix.length(), offset);
        String rest = path.substring(offset + 1);
        Map adapters = (Map)s_assetAdapters.get(context);
        if (adapters != null && adapters.containsKey(base)) {
            DomainObjectTraversalAdapter adapter = (DomainObjectTraversalAdapter)adapters.get(base);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Delegate to asset adapter " + base + " " + rest + " " + adapter));
            }
            return adapter.processProperty(obj, "/object/" + rest, prop, context);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Delegate to primary adapter " + base + " " + rest));
        }
        return super.processProperty(obj, path, prop, context);
    }
}

