/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.contenttypes.ContentTypeHelper;
import com.arsdigita.cms.search.ContentPageMetadataProvider;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ContentTypeHelperImpl
implements ContentTypeHelper {
    private static final Logger s_log = Logger.getLogger(ContentTypeHelperImpl.class);
    private ContentType m_type;
    private ContentType m_parent;
    private String m_label;
    private String m_labelKey;
    private String m_labelBundle;
    private String m_description;
    private String m_descriptionKey;
    private String m_descriptionBundle;
    private String m_objectType;
    private String m_className;
    private String m_createComponent;
    private AuthoringKit m_kit;
    private String m_mode;

    @Override
    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public void setLabelBundle(String labelBundle) {
        this.m_labelBundle = labelBundle;
    }

    @Override
    public String getLabelBundle() {
        return this.m_labelBundle;
    }

    @Override
    public void setLabelKey(String labelKey) {
        this.m_labelKey = labelKey;
    }

    @Override
    public String getLabelKey() {
        return this.m_labelKey;
    }

    @Override
    public void setMode(String mode) {
        this.m_mode = mode.toLowerCase();
    }

    @Override
    public boolean isInternal() {
        return this.m_mode.equalsIgnoreCase("internal");
    }

    @Override
    public boolean isHidden() {
        return this.m_mode.equalsIgnoreCase("hidden");
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public void setDescriptionBundle(String descriptionBundle) {
        this.m_descriptionBundle = descriptionBundle;
    }

    @Override
    public String getDescriptionBundle() {
        return this.m_descriptionBundle;
    }

    @Override
    public void setDescriptionKey(String descriptionKey) {
        this.m_descriptionKey = descriptionKey;
    }

    @Override
    public String getDescriptionKey() {
        return this.m_descriptionKey;
    }

    @Override
    public void setObjectType(String objType) {
        this.m_objectType = objType;
    }

    @Override
    public String getObjectType() {
        return this.m_objectType;
    }

    @Override
    public void setClassName(String classname) {
        this.m_className = classname;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public void setCreateComponent(String createComponent) {
        this.m_createComponent = createComponent;
    }

    @Override
    public AuthoringKit getAuthoringKit() {
        Assert.exists((Object)((Object)this.m_kit));
        return this.m_kit;
    }

    @Override
    public ContentType getContentType() {
        Assert.exists((Object)((Object)this.m_type));
        return this.m_type;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setParentType(String parentType) {
    }

    @Override
    public ContentType createType() {
        Assert.exists((Object)this.m_label);
        Assert.exists((Object)this.m_description);
        Assert.exists((Object)this.m_objectType);
        Assert.exists((Object)this.m_className);
        try {
            s_log.debug((Object)"making new content type");
            this.m_type = ContentType.findByAssociatedObjectType(this.m_objectType);
            this.m_type.setLabel(this.m_label);
            this.m_type.setDescription(this.m_description);
            this.m_type.save();
        }
        catch (DataObjectNotFoundException e) {
            s_log.debug((Object)"Looking for content type");
            s_log.debug((Object)("Creating ContentType Label: " + this.m_label + " Description: " + this.m_description + " className: " + this.m_className + " AssociatedObjectType: " + this.m_objectType));
            this.m_type = new ContentType();
            this.m_type.setLabel(this.m_label);
            this.m_type.setDescription(this.m_description);
            this.m_type.setClassName(this.m_className);
            this.m_type.setAssociatedObjectType(this.m_objectType);
            this.m_type.setMode(this.m_mode);
            this.createPedigree(this.m_type);
            this.m_type.save();
        }
        ObjectType type = SessionManager.getMetadataRoot().getObjectType(this.m_objectType);
        if (type == null) {
            StringBuffer buffer = new StringBuffer();
            Collection objectTypes = SessionManager.getMetadataRoot().getObjectTypes();
            for (Object obj : objectTypes) {
                ObjectType objectType = (ObjectType)obj;
                buffer.append('\t');
                buffer.append(objectType.getQualifiedName());
                buffer.append('\n');
            }
            throw new IllegalArgumentException(String.format("No object type for '%s'. Available object types:\n%s", this.m_objectType, buffer.toString()));
        }
        if (type.isSubtypeOf("com.arsdigita.cms.ContentPage") && !this.isInternal()) {
            s_log.debug((Object)("Registering search adapter for " + this.m_objectType));
            MetadataProviderRegistry.registerAdapter((String)this.m_objectType, (MetadataProvider)new ContentPageMetadataProvider());
        }
        Assert.exists((Object)((Object)this.m_type));
        return this.m_type;
    }

    @Override
    public AuthoringKit createAuthoringKit() {
        Assert.exists((Object)((Object)this.m_type));
        s_log.debug((Object)("Createcomponent is : " + this.m_createComponent));
        this.m_kit = this.m_type.getAuthoringKit();
        if (this.m_kit != null) {
            if (this.m_createComponent != null) {
                this.m_kit.setCreateComponent(this.m_createComponent);
            }
            AuthoringStepCollection ac = this.m_kit.getSteps();
            while (ac.next()) {
                AuthoringStep step = ac.getAuthoringStep();
                s_log.debug((Object)("Deleting authoringStep " + step.getLabel()));
                this.m_kit.removeStep(step);
                step.delete();
            }
        } else {
            this.m_kit = this.m_type.createAuthoringKit(this.m_createComponent);
        }
        s_log.debug((Object)"saving authoring kit");
        this.m_kit.save();
        this.m_type.save();
        return this.m_kit;
    }

    @Override
    public void addAuthoringStep(String label, String description, String component, BigDecimal ordering) {
        this.addAuthoringStep(label, null, description, null, component, ordering);
    }

    @Override
    public void addAuthoringStep(String labelKey, String labelBundle, String descriptionKey, String descriptionBundle, String component, BigDecimal ordering) {
        s_log.debug((Object)("Creating AuthoringStep  LabelKey: " + labelKey + " LabelBundle: " + labelBundle + " DescriptionKey: " + descriptionKey + " DescriptionBundle: " + descriptionBundle + " Component " + component + " Ordering: " + ordering));
        Assert.exists((Object)((Object)this.m_kit));
        Assert.exists((Object)labelKey);
        Assert.exists((Object)descriptionKey);
        Assert.exists((Object)component);
        Assert.exists((Object)ordering);
        this.m_kit.createStep(labelKey, labelBundle, descriptionKey, descriptionBundle, component, ordering);
        this.m_kit.save();
        this.m_type.save();
    }

    @Override
    public void saveType() {
        this.m_kit.save();
        this.m_type.save();
    }

    private void createPedigree(ContentType type) {
        ContentType parent = null;
        ArrayList<ContentType> parents = new ArrayList<ContentType>();
        ContentTypeCollection cts = ContentType.getAllContentTypes();
        while (cts.next()) {
            ContentType ct = cts.getContentType();
            try {
                Class.forName(type.getClassName()).asSubclass(Class.forName(ct.getClassName()));
            }
            catch (Exception ex) {
                continue;
            }
            if (type.getClassName().equals(ct.getClassName()) || parent != null && (parent.getAncestors() == null || ct.getAncestors() == null || parent.getAncestors().length() >= ct.getAncestors().length())) continue;
            parent = ct;
            parents.add(ct);
        }
        if (parent != null && !parent.getClassName().equals(type.getClassName())) {
            if (parent.getAncestors() != null) {
                String parentAncestors = parent.getAncestors();
                StringTokenizer strTok = new StringTokenizer(parentAncestors, "/");
                while (strTok.hasMoreElements()) {
                    BigDecimal ctID = new BigDecimal(strTok.nextToken());
                    try {
                        ContentType ct = new ContentType(ctID);
                        ct.addDescendants(ctID);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    type.addAncestor(ctID);
                }
            }
            type.addAncestor(parent.getID());
            parent.addDescendants(type.getID());
        }
    }
}

