/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.contenttypes.GenericAddressConfig;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.LocaleNegotiator;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class GenericAddress
extends ContentPage {
    private static final Logger logger = Logger.getLogger(GenericAddress.class);
    public static final String ADDRESS = "address";
    public static final String POSTAL_CODE = "postalCode";
    public static final String CITY = "city";
    public static final String STATE = "state";
    public static final String ISO_COUNTRY_CODE = "isoCountryCode";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericAddress";
    private static GenericAddressConfig s_config = new GenericAddressConfig();

    public static GenericAddressConfig getConfig() {
        return s_config;
    }

    public GenericAddress() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public GenericAddress(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericAddress(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public GenericAddress(DataObject obj) {
        super(obj);
    }

    public GenericAddress(String type) {
        super(type);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)((Object)this.getContentType()), ContentType.class);
    }

    public String getAddress() {
        return (String)this.get(ADDRESS);
    }

    public void setAddress(String address) {
        this.set(ADDRESS, address);
    }

    public String getIsoCountryCode() {
        return (String)this.get(ISO_COUNTRY_CODE);
    }

    public void setIsoCountryCode(String isoCountryCode) {
        this.set(ISO_COUNTRY_CODE, isoCountryCode);
    }

    public String getPostalCode() {
        return (String)this.get(POSTAL_CODE);
    }

    public void setPostalCode(String postalCode) {
        this.set(POSTAL_CODE, postalCode);
    }

    public String getCity() {
        return (String)this.get(CITY);
    }

    public void setCity(String city) {
        this.set(CITY, city);
    }

    public String getState() {
        return (String)this.get(STATE);
    }

    public void setState(String state) {
        this.set(STATE, state);
    }

    public static String getCountryNameFromIsoCode(String isoCountryCode) {
        LocaleNegotiator negotiatedLocale = new LocaleNegotiator("", "", "", null);
        Locale locale = new Locale("", isoCountryCode);
        return locale.getDisplayCountry(negotiatedLocale.getLocale());
    }

    public static TreeMap getSortedListOfCountries(Locale inLang) {
        LocaleNegotiator negotiatedLocale = new LocaleNegotiator("", "", "", null);
        String[] countries = Locale.getISOCountries();
        TreeMap<String, String> countryNames = new TreeMap<String, String>();
        for (String country : countries) {
            if (inLang != null) {
                countryNames.put(new Locale("", country).getDisplayCountry(inLang), country);
                continue;
            }
            countryNames.put(new Locale("", country).getDisplayCountry(negotiatedLocale.getLocale()), country);
        }
        return countryNames;
    }

    static {
        logger.debug((Object)"Static initializer is starting...");
        s_config.load();
        logger.debug((Object)"Static initializer finished.");
    }
}

