/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GenericArticle
extends ContentPage {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericArticle";
    public static final String TEXT_ASSET = "textAsset";
    protected static final int SUMMARY_SIZE = 1024;
    private static Logger s_log = Logger.getLogger(GenericArticle.class);

    public GenericArticle() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public GenericArticle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public GenericArticle(String type) {
        super(type);
    }

    public GenericArticle(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericArticle(DataObject obj) {
        super(obj);
    }

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public TextAsset getTextAsset() {
        DataObject text = (DataObject)this.get(TEXT_ASSET);
        if (text == null) {
            return null;
        }
        return new TextAsset(text);
    }

    public void setTextAsset(TextAsset text) {
        this.setAssociation(TEXT_ASSET, (DomainObject)text);
    }

    @Override
    public String getSearchSummary() {
        TextAsset a = this.getTextAsset();
        if (a == null) {
            return "";
        }
        return StringUtils.truncateString((String)a.getText(), (int)1024, (boolean)true);
    }
}

