/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.RelationAttributeInterface;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.GenericContactBundle;
import com.arsdigita.cms.contenttypes.GenericContactConfig;
import com.arsdigita.cms.contenttypes.GenericContactEntry;
import com.arsdigita.cms.contenttypes.GenericContactEntryCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonContactCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class GenericContact
extends ContentPage
implements RelationAttributeInterface,
ExtraXMLGenerator {
    private static final Logger logger = Logger.getLogger(GenericContact.class);
    public static final String PERSON = "person";
    public static final String ADDRESS = "address";
    public static final String CONTACT_ENTRIES = "contactentries";
    public static final String CONTACTS_KEY = "link.linkKey";
    private static final String RELATION_ATTRIBUTES = "person.link_key:GenericContactTypes;contactentries.key:GenericContactEntryKeys";
    private static final GenericContactConfig s_config = new GenericContactConfig();
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericContact";

    public GenericContact() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public GenericContact(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericContact(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public GenericContact(DataObject obj) {
        super(obj);
    }

    public GenericContact(String type) {
        super(type);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)((Object)this.getContentType()), ContentType.class);
    }

    public static final GenericContactConfig getConfig() {
        return s_config;
    }

    public GenericContactBundle getGenericContactBundle() {
        return (GenericContactBundle)this.getContentBundle();
    }

    public GenericPerson getPerson() {
        return this.getGenericContactBundle().getPerson();
    }

    public void setPerson(GenericPerson person, String contactType) {
        this.getGenericContactBundle().setPerson(person, contactType);
    }

    public void unsetPerson() {
        this.getGenericContactBundle().unsetPerson();
    }

    public GenericAddress getAddress() {
        return (GenericAddress)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(ADDRESS)));
    }

    public void setAddress(GenericAddress address) {
        this.set(ADDRESS, address);
    }

    public void unsetAddress() {
        this.set(ADDRESS, null);
    }

    public GenericContactEntryCollection getContactEntries() {
        return new GenericContactEntryCollection((DataCollection)this.get(CONTACT_ENTRIES));
    }

    public void addContactEntry(GenericContactEntry contactEntry) {
        Assert.exists((Object)contactEntry, GenericContactEntry.class);
        this.add(CONTACT_ENTRIES, (DomainObject)contactEntry);
    }

    public void removeContactEntry(GenericContactEntry contactEntry) {
        Assert.exists((Object)contactEntry, GenericContactEntry.class);
        this.remove(CONTACT_ENTRIES, (DomainObject)contactEntry);
    }

    public String getContactType() {
        GenericPerson person = this.getPerson();
        if (person != null) {
            GenericPersonContactCollection collection = person.getContacts();
            collection.next();
            String contactType = collection.getContactType();
            collection.close();
            return contactType;
        }
        return null;
    }

    public void setContactType(String contactType) {
        GenericPerson person = this.getPerson();
        if (person != null) {
            GenericPersonContactCollection collection = person.getContacts();
            collection.next();
            DataObject link = (DataObject)collection.get("link");
            link.set(CONTACTS_KEY, (Object)contactType);
        }
    }

    public boolean hasPerson() {
        return this.getPerson() != null;
    }

    public boolean hasAddress() {
        return this.getAddress() != null;
    }

    public boolean hasContactEntries() {
        return !this.getContactEntries().isEmpty();
    }

    @Override
    public boolean hasRelationAttributes() {
        return !RELATION_ATTRIBUTES.isEmpty();
    }

    @Override
    public boolean hasRelationAttributeProperty(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringTokenizer getRelationAttributes() {
        return new StringTokenizer(RELATION_ATTRIBUTES, ";");
    }

    @Override
    public String getRelationAttributeKeyName(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return token.substring(token.indexOf(".") + 1, token.indexOf(":"));
        }
        return null;
    }

    @Override
    public String getRelationAttributeName(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return token.substring(token.indexOf(":") + 1);
        }
        return null;
    }

    @Override
    public String getRelationAttributeKey(String propertyName) {
        return null;
    }

    @Override
    public void generateXML(ContentItem item, Element element, PageState state) {
        if (this.getPerson() != null) {
            Element personElem = element.newChildElement(PERSON);
            GenericPerson person = this.getPerson();
            if (person.getSurname() != null && !person.getSurname().isEmpty()) {
                Element surnameElem = personElem.newChildElement("surname");
                surnameElem.setText(person.getSurname());
            }
            if (person.getGivenName() != null && !person.getGivenName().isEmpty()) {
                Element givenNameElem = personElem.newChildElement("givenname");
                givenNameElem.setText(person.getGivenName());
            }
            if (person.getTitlePre() != null && !person.getTitlePre().isEmpty()) {
                Element titlePreElem = personElem.newChildElement("titlepre");
                titlePreElem.setText(person.getTitlePre());
            }
            if (person.getTitlePost() != null && !person.getTitlePost().isEmpty()) {
                Element titlePostElem = personElem.newChildElement("titlepost");
                titlePostElem.setText(person.getTitlePost());
            }
        }
        StringTokenizer keys = s_config.getContactEntryKeys();
        Element contactKeysElem = element.newChildElement("contactEntryKeys");
        while (keys.hasMoreElements()) {
            contactKeysElem.newChildElement("entryKey").setText(keys.nextToken());
        }
    }

    @Override
    public void addGlobalStateParams(Page p) {
    }

    @Override
    public void setListMode(boolean listMode) {
    }

    @Override
    public List<ExtraXMLGenerator> getExtraXMLGenerators() {
        List<ExtraXMLGenerator> generators = super.getExtraXMLGenerators();
        generators.add(this);
        return generators;
    }

    static {
        logger.debug((Object)"Static initializer is starting...");
        s_config.load();
        logger.debug((Object)"Static initializer finished");
    }
}

