/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundle;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonBundle;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class GenericContactBundle
extends ContentBundle {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericContactBundle";
    public static final String PERSON = "person";

    public GenericContactBundle(ContentItem primary) {
        super(BASE_DATA_OBJECT_TYPE);
        Assert.exists((Object)primary, ContentItem.class);
        this.setDefaultLanguage(primary.getLanguage());
        this.setContentType(primary.getContentType());
        this.addInstance(primary);
        super.setName(primary.getName());
    }

    public GenericContactBundle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public GenericContactBundle(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericContactBundle(DataObject dobj) {
        super(dobj);
    }

    public GenericContactBundle(String type) {
        super(type);
    }

    @Override
    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        String attribute = property.getName();
        if (copier.getCopyType() == 1) {
            GenericContactBundle contactBundle = (GenericContactBundle)source;
            if (PERSON.equals(attribute)) {
                DataCollection persons = (DataCollection)contactBundle.get(PERSON);
                while (persons.next()) {
                    this.createPersonAssoc(persons);
                }
                return true;
            }
            if ("organizationalunit".equals(attribute)) {
                DataCollection orgaunits = (DataCollection)contactBundle.get("organizationalunit");
                while (orgaunits.next()) {
                    this.createOrgaUnitAssoc(orgaunits);
                }
                return true;
            }
            return super.copyProperty(source, property, copier);
        }
        return super.copyProperty(source, property, copier);
    }

    private void createPersonAssoc(DataCollection persons) {
        GenericPersonBundle draftPerson = (GenericPersonBundle)DomainObjectFactory.newInstance((DataObject)persons.getDataObject());
        GenericPersonBundle livePerson = (GenericPersonBundle)draftPerson.getLiveVersion();
        if (livePerson != null) {
            DataObject link = this.add(PERSON, (DomainObject)livePerson);
            link.set("linkKey", persons.get("link.linkKey"));
            link.set("linkOrder", persons.get("link.linkOrder"));
            link.save();
        }
    }

    private void createOrgaUnitAssoc(DataCollection orgaunits) {
        GenericOrganizationalUnitBundle draftOrga = (GenericOrganizationalUnitBundle)DomainObjectFactory.newInstance((DataObject)orgaunits.getDataObject());
        GenericOrganizationalUnitBundle liveOrga = (GenericOrganizationalUnitBundle)draftOrga.getLiveVersion();
        if (liveOrga != null) {
            DataObject link = this.add("organizationalunit", (DomainObject)liveOrga);
            link.set("contact_type", orgaunits.get("link.contact_type"));
            link.set("contact_order", orgaunits.get("link.contact_order"));
            link.save();
        }
    }

    public GenericPerson getPerson() {
        DataCollection collection = (DataCollection)this.get(PERSON);
        if (collection.size() == 0L) {
            return null;
        }
        collection.next();
        DataObject dobj = collection.getDataObject();
        collection.close();
        GenericPersonBundle bundle = (GenericPersonBundle)DomainObjectFactory.newInstance((DataObject)dobj);
        return (GenericPerson)bundle.getPrimaryInstance();
    }

    public void setPerson(GenericPerson person, String contactType) {
        if (this.getPerson() != null) {
            this.unsetPerson();
        }
        if (person != null) {
            Assert.exists((Object)person, GenericPerson.class);
            DataObject link = this.add(PERSON, (DomainObject)person.getGenericPersonBundle());
            link.set("linkKey", (Object)contactType);
            link.set("linkOrder", (Object)new BigDecimal(person.getContacts().size()));
            link.save();
        }
    }

    public void unsetPerson() {
        GenericPerson oldPerson = this.getPerson();
        if (oldPerson != null) {
            this.remove(PERSON, (DomainObject)oldPerson.getGenericPersonBundle());
        }
    }
}

