/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.RelationAttributeInterface;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class GenericContactEntry
extends ContentItem
implements RelationAttributeInterface {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericContactEntry";
    private static final String BASE_DATA_OBJECT_PACKAGE = "com.arsdigita.cms.contenttypes";
    private static final Logger s_log = Logger.getLogger(GenericContactEntry.class);
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String DESCRIPTION = "description";
    private static final String RELATION_ATTRIBUTES = "key.key:GenericContactEntryKeys";

    public GenericContactEntry() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public GenericContactEntry(String typeName) {
        super(typeName);
    }

    public GenericContactEntry(OID oid) {
        super(oid);
    }

    public GenericContactEntry(DataObject object) {
        super(object);
    }

    public GenericContactEntry(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericContactEntry(GenericContact contact, String key, String value, String description) {
        this();
        this.setName(key + " for " + contact.getName() + "(" + contact.getID() + ")");
        this.setKey(key);
        this.setValue(value);
        this.setDescription(description);
        this.save();
    }

    public String getKey() {
        return (String)this.get(KEY);
    }

    public void setKey(String key) {
        this.set(KEY, key);
    }

    public String getValue() {
        return (String)this.get(VALUE);
    }

    public void setValue(String value) {
        this.set(VALUE, value);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    @Override
    public boolean hasRelationAttributes() {
        return !RELATION_ATTRIBUTES.isEmpty();
    }

    @Override
    public boolean hasRelationAttributeProperty(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringTokenizer getRelationAttributes() {
        return new StringTokenizer(RELATION_ATTRIBUTES, ";");
    }

    @Override
    public String getRelationAttributeKeyName(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return token.substring(token.indexOf(".") + 1, token.indexOf(":"));
        }
        return null;
    }

    @Override
    public String getRelationAttributeName(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return token.substring(token.indexOf(":") + 1);
        }
        return null;
    }

    @Override
    public String getRelationAttributeKey(String propertyName) {
        return this.getKey();
    }
}

