/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactEntry;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.persistence.DataCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class GenericContactEntryCollection
extends DomainCollection {
    private TreeSet m_sortedCollection = new TreeSet(new ContactEntryComparator());
    private Iterator m_iterator;
    private boolean m_firstElem;
    private GenericContactEntry m_currentContactEntry;

    public GenericContactEntryCollection(GenericContact contact) {
        this((DataCollection)contact.getContactEntries());
    }

    public GenericContactEntryCollection(DataCollection dataCollection) {
        super(dataCollection);
        this.sortCollection();
    }

    public boolean next() {
        boolean retVal = this.m_iterator.hasNext();
        if (retVal) {
            this.m_currentContactEntry = (GenericContactEntry)this.m_iterator.next();
            this.m_firstElem = false;
        }
        return retVal;
    }

    public boolean isBeforeFirst() {
        return false;
    }

    public boolean isAfterLast() {
        return false;
    }

    public boolean isFirst() {
        return this.m_firstElem;
    }

    public boolean isLast() {
        return !this.m_iterator.hasNext();
    }

    public boolean isEmpty() {
        return this.m_sortedCollection.isEmpty();
    }

    public long size() {
        return this.m_sortedCollection.size();
    }

    public void reset() {
        super.reset();
        this.m_iterator = null;
        this.m_currentContactEntry = null;
        this.m_sortedCollection = new TreeSet(new ContactEntryComparator());
        this.sortCollection();
    }

    public void rewind() {
        this.m_iterator = this.m_sortedCollection.iterator();
    }

    public final String getKey() {
        return this.getContactEntry().getKey();
    }

    public final String getDescription() {
        return this.getContactEntry().getDescription();
    }

    public final String getValue() {
        return this.getContactEntry().getValue();
    }

    public GenericContactEntry getContactEntry() {
        return this.m_currentContactEntry;
    }

    private void sortCollection() {
        this.m_dataCollection.rewind();
        while (this.m_dataCollection.next()) {
            this.m_sortedCollection.add(new GenericContactEntry(this.m_dataCollection.getDataObject()));
        }
        this.m_iterator = this.m_sortedCollection.iterator();
        this.m_firstElem = true;
    }

    private class ContactEntryComparator
    implements Comparator {
        private ContactEntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            int retVal = 0;
            if (o1 instanceof GenericContactEntry && o2 instanceof GenericContactEntry) {
                GenericContactEntry bc1 = (GenericContactEntry)o1;
                GenericContactEntry bc2 = (GenericContactEntry)o2;
                retVal = GenericContact.getConfig().getKeyIndex(bc1.getKey()) - GenericContact.getConfig().getKeyIndex(bc2.getKey());
                if (retVal == 0) {
                    retVal = -1;
                }
            }
            return retVal;
        }
    }
}

