/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundle;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSuperiorCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnit
extends ContentPage {
    private static final Logger logger = Logger.getLogger(GenericOrganizationalUnit.class);
    public static final String ADDENDUM = "addendum";
    public static final String CONTACTS = "contacts";
    public static final String PERSONS = "persons";
    public static final String SUPERIOR_ORGAUNITS = "superiorOrgaunits";
    public static final String SUBORDINATE_ORGAUNITS = "subordinateOrgaunits";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericOrganizationalUnit";

    public GenericOrganizationalUnit() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public GenericOrganizationalUnit(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericOrganizationalUnit(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public GenericOrganizationalUnit(DataObject obj) {
        super(obj);
    }

    public GenericOrganizationalUnit(String type) {
        super(type);
    }

    public GenericOrganizationalUnitBundle getGenericOrganizationalUnitBundle() {
        return (GenericOrganizationalUnitBundle)this.getContentBundle();
    }

    public String getAddendum() {
        return (String)this.get(ADDENDUM);
    }

    public void setAddendum(String addendum) {
        this.set(ADDENDUM, addendum);
    }

    public GenericOrganizationalUnitContactCollection getContacts() {
        DataCollection dataColl = (DataCollection)this.getContentBundle().get(CONTACTS);
        return new GenericOrganizationalUnitContactCollection(dataColl);
    }

    public void addContact(GenericContact contact, String contactType) {
        this.getGenericOrganizationalUnitBundle().addContact(contact, contactType);
    }

    public void removeContact(GenericContact contact) {
        this.getGenericOrganizationalUnitBundle().removeContact(contact);
    }

    public boolean hasContacts() {
        return this.getGenericOrganizationalUnitBundle().hasContacts();
    }

    public GenericOrganizationalUnitPersonCollection getPersons() {
        DataCollection dataColl = (DataCollection)this.getContentBundle().get(PERSONS);
        logger.debug((Object)String.format("GenericOrganizationalUnitPersonCollection size = %d", dataColl.size()));
        return new GenericOrganizationalUnitPersonCollection(dataColl);
    }

    public void addPerson(GenericPerson person, String role, String status) {
        this.getGenericOrganizationalUnitBundle().addPerson(person, role, status);
    }

    public void removePerson(GenericPerson person) {
        logger.debug((Object)"Removing person association...");
        this.getGenericOrganizationalUnitBundle().removePerson(person);
    }

    public boolean hasPersons() {
        return this.getGenericOrganizationalUnitBundle().hasPersons();
    }

    public GenericOrganizationalUnitSuperiorCollection getSuperiorOrgaUnits() {
        return this.getGenericOrganizationalUnitBundle().getSuperiorOrgaUnits();
    }

    public void addSuperiorOrgaUnit(GenericOrganizationalUnit orgaunit, String assocType) {
        this.getGenericOrganizationalUnitBundle().addSuperiorOrgaUnit(orgaunit, assocType);
    }

    public void addSuperiorOrgaUnit(GenericOrganizationalUnit orgaunit) {
        this.addSuperiorOrgaUnit(orgaunit, "");
    }

    public void removeSuperiorOrgaUnit(GenericOrganizationalUnit orgaunit) {
        this.getGenericOrganizationalUnitBundle().removeSuperiorOrgaUnit(orgaunit);
    }

    public boolean hasSuperiorOrgaUnits() {
        return this.getGenericOrganizationalUnitBundle().hasSuperiorOrgaUnits();
    }

    public GenericOrganizationalUnitSubordinateCollection getSubordinateOrgaUnits() {
        return this.getGenericOrganizationalUnitBundle().getSubordinateOrgaUnits();
    }

    public void addSubordinateOrgaUnit(GenericOrganizationalUnit orgaunit, String assocType) {
        this.getGenericOrganizationalUnitBundle().addSubordinateOrgaUnit(orgaunit, assocType);
    }

    public void addSubordinateOrgaUnit(GenericOrganizationalUnit orgaunit) {
        this.addSubordinateOrgaUnit(orgaunit, "");
    }

    public void removeSubordinateOrgaUnit(GenericOrganizationalUnit orgaunit) {
        this.getGenericOrganizationalUnitBundle().removeSubordinateOrgaUnit(orgaunit);
    }

    public boolean hasSubordinateOrgaUnits() {
        return this.getGenericOrganizationalUnitBundle().hasSubordinateOrgaUnits();
    }

    @Override
    public String getSearchSummary() {
        return String.format("%s %s", this.getTitle(), this.getAddendum());
    }
}

