/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactBundle;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSuperiorCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonBundle;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class GenericOrganizationalUnitBundle
extends ContentBundle {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundle";
    public static final String PERSONS = "persons";
    public static final String ORGAUNITS = "organizationalunits";
    public static final String CONTACTS = "contacts";
    public static final String SUPERIOR_ORGAUNITS = "superiorOrgaunits";
    public static final String SUBORDINATE_ORGAUNITS = "subordinateOrgaunits";

    public GenericOrganizationalUnitBundle(ContentItem primary) {
        super(BASE_DATA_OBJECT_TYPE);
        Assert.exists((Object)primary, ContentItem.class);
        this.setDefaultLanguage(primary.getLanguage());
        this.setContentType(primary.getContentType());
        this.addInstance(primary);
        super.setName(primary.getName());
    }

    public GenericOrganizationalUnitBundle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public GenericOrganizationalUnitBundle(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericOrganizationalUnitBundle(DataObject dobj) {
        super(dobj);
    }

    public GenericOrganizationalUnitBundle(String type) {
        super(type);
    }

    public GenericOrganizationalUnitPersonCollection getPersons() {
        return new GenericOrganizationalUnitPersonCollection((DataCollection)this.get(PERSONS));
    }

    public void addPerson(GenericPerson person, String role, String status) {
        Assert.exists((Object)person, GenericPerson.class);
        DataObject link = this.add(PERSONS, (DomainObject)person.getGenericPersonBundle());
        link.set("role_name", (Object)role);
        link.set("status", (Object)status);
        link.save();
    }

    public void removePerson(GenericPerson person) {
        Assert.exists((Object)person, GenericPerson.class);
        this.remove(PERSONS, (DomainObject)person.getContentBundle());
    }

    public boolean hasPersons() {
        return !this.getPersons().isEmpty();
    }

    public GenericOrganizationalUnitContactCollection getContacts() {
        return new GenericOrganizationalUnitContactCollection((DataCollection)this.get(CONTACTS));
    }

    public void addContact(GenericContact contact, String contactType) {
        Assert.exists((Object)contact, GenericContact.class);
        DataObject link = this.add(CONTACTS, (DomainObject)contact.getContentBundle());
        link.set("contact_type", (Object)contactType);
        link.set("contact_order", (Object)((int)this.getContacts().size()));
        link.save();
    }

    public void removeContact(GenericContact contact) {
        Assert.exists((Object)contact, GenericContact.class);
        this.remove(CONTACTS, (DomainObject)contact.getContentBundle());
    }

    public boolean hasContacts() {
        return !this.getContacts().isEmpty();
    }

    public GenericOrganizationalUnitSuperiorCollection getSuperiorOrgaUnits() {
        return new GenericOrganizationalUnitSuperiorCollection((DataCollection)this.get(SUPERIOR_ORGAUNITS));
    }

    public void addSuperiorOrgaUnit(GenericOrganizationalUnit orgaunit, String assocType) {
        Assert.exists((Object)orgaunit, GenericOrganizationalUnit.class);
        DataObject link = this.add(SUPERIOR_ORGAUNITS, (DomainObject)orgaunit.getGenericOrganizationalUnitBundle());
        link.set("assocType", (Object)assocType);
        link.set("superiorOrgaUnitOrder", (Object)((int)this.getSuperiorOrgaUnits().size()));
        link.set("subordinateOrgaUnitOrder", (Object)((int)this.getSubordinateOrgaUnits().size() + 1));
        link.save();
    }

    public void addSuperiorOrgaUnit(GenericOrganizationalUnit orgaunit) {
        this.addSuperiorOrgaUnit(orgaunit, "");
    }

    public void removeSuperiorOrgaUnit(GenericOrganizationalUnit orgaunit) {
        Assert.exists((Object)orgaunit, GenericOrganizationalUnit.class);
        this.remove(SUPERIOR_ORGAUNITS, (DomainObject)orgaunit.getGenericOrganizationalUnitBundle());
    }

    public boolean hasSuperiorOrgaUnits() {
        return !this.getSuperiorOrgaUnits().isEmpty();
    }

    public GenericOrganizationalUnitSubordinateCollection getSubordinateOrgaUnits() {
        DataCollection dataCollection = (DataCollection)this.get(SUBORDINATE_ORGAUNITS);
        return new GenericOrganizationalUnitSubordinateCollection(dataCollection);
    }

    public void addSubordinateOrgaUnit(GenericOrganizationalUnit orgaunit, String assocType) {
        Assert.exists((Object)orgaunit, GenericOrganizationalUnit.class);
        DataObject link = this.add(SUBORDINATE_ORGAUNITS, (DomainObject)orgaunit.getGenericOrganizationalUnitBundle());
        link.set("assocType", (Object)assocType);
        link.set("subordinateOrgaUnitOrder", (Object)((int)this.getSubordinateOrgaUnits().size()));
        link.set("superiorOrgaUnitOrder", (Object)((int)this.getSuperiorOrgaUnits().size() + 1));
        link.save();
    }

    public void addSubordinateOrgaUnit(GenericOrganizationalUnit orgaunit) {
        this.addSubordinateOrgaUnit(orgaunit, "");
    }

    public void removeSubordinateOrgaUnit(GenericOrganizationalUnit orgaunit) {
        Assert.exists((Object)orgaunit, GenericOrganizationalUnit.class);
        this.remove(SUBORDINATE_ORGAUNITS, (DomainObject)orgaunit.getGenericOrganizationalUnitBundle());
    }

    public boolean hasSubordinateOrgaUnits() {
        return !this.getSubordinateOrgaUnits().isEmpty();
    }

    @Override
    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        String attribute = property.getName();
        if (copier.getCopyType() == 1) {
            GenericOrganizationalUnitBundle orgaBundle = (GenericOrganizationalUnitBundle)source;
            if (CONTACTS.equals(attribute)) {
                DataCollection contacts = (DataCollection)orgaBundle.get(CONTACTS);
                while (contacts.next()) {
                    this.createContactAssoc(contacts);
                }
                return true;
            }
            if (PERSONS.equals(attribute)) {
                DataCollection persons = (DataCollection)orgaBundle.get(PERSONS);
                while (persons.next()) {
                    this.createPersonAssoc(persons);
                }
                return true;
            }
            if (SUPERIOR_ORGAUNITS.equals(attribute)) {
                DataCollection superOrgaUnits = (DataCollection)orgaBundle.get(SUPERIOR_ORGAUNITS);
                while (superOrgaUnits.next()) {
                    this.createSuperiorAssoc(superOrgaUnits);
                }
                return true;
            }
            if (SUBORDINATE_ORGAUNITS.equals(attribute)) {
                DataCollection subOrgaUnits = (DataCollection)orgaBundle.get(SUBORDINATE_ORGAUNITS);
                while (subOrgaUnits.next()) {
                    this.createSubordinateAssoc(subOrgaUnits);
                }
                return true;
            }
            return super.copyProperty(source, property, copier);
        }
        return super.copyProperty(source, property, copier);
    }

    private void createContactAssoc(DataCollection contacts) {
        GenericContactBundle draftContact = (GenericContactBundle)DomainObjectFactory.newInstance((DataObject)contacts.getDataObject());
        GenericContactBundle liveContact = (GenericContactBundle)draftContact.getLiveVersion();
        if (liveContact != null) {
            DataObject link = this.add(CONTACTS, (DomainObject)liveContact);
            link.set("contact_type", contacts.get("link.contact_type"));
            link.set("contact_order", contacts.get("link.contact_order"));
            link.save();
        }
    }

    private void createPersonAssoc(DataCollection persons) {
        GenericPersonBundle draftPerson = (GenericPersonBundle)DomainObjectFactory.newInstance((DataObject)persons.getDataObject());
        GenericPersonBundle livePerson = (GenericPersonBundle)draftPerson.getLiveVersion();
        if (livePerson != null) {
            DataObject link = this.add(PERSONS, (DomainObject)livePerson);
            link.set("role_name", persons.get("link.role_name"));
            link.set("status", persons.get("link.status"));
            link.save();
        }
    }

    private void createSuperiorAssoc(DataCollection superOrgaUnits) {
        GenericOrganizationalUnitBundle draftOrga = (GenericOrganizationalUnitBundle)DomainObjectFactory.newInstance((DataObject)superOrgaUnits.getDataObject());
        GenericOrganizationalUnitBundle liveOrga = (GenericOrganizationalUnitBundle)draftOrga.getLiveVersion();
        if (liveOrga != null) {
            DataObject link = this.add(SUPERIOR_ORGAUNITS, (DomainObject)liveOrga);
            link.set("assocType", superOrgaUnits.get("link.assocType"));
            link.set("superiorOrgaUnitOrder", superOrgaUnits.get("link.superiorOrgaUnitOrder"));
            link.set("subordinateOrgaUnitOrder", superOrgaUnits.get("link.subordinateOrgaUnitOrder"));
            link.save();
        }
    }

    private void createSubordinateAssoc(DataCollection subOrgaUnits) {
        GenericOrganizationalUnitBundle draftOrga = (GenericOrganizationalUnitBundle)DomainObjectFactory.newInstance((DataObject)subOrgaUnits.getDataObject());
        GenericOrganizationalUnitBundle liveOrga = (GenericOrganizationalUnitBundle)draftOrga.getLiveVersion();
        if (liveOrga != null) {
            DataObject link = this.add(SUBORDINATE_ORGAUNITS, (DomainObject)liveOrga);
            link.set("assocType", subOrgaUnits.get("link.assocType"));
            link.set("subordinateOrgaUnitOrder", subOrgaUnits.get("link.subordinateOrgaUnitOrder"));
            link.set("superiorOrgaUnitOrder", subOrgaUnits.get("link.superiorOrgaUnitOrder"));
            link.save();
        }
    }
}

