/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactEntryCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonBundle;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnitContactCollection
extends DomainCollection {
    private static final Logger s_log = Logger.getLogger(GenericOrganizationalUnitContactCollection.class);
    public static final String LINK_CONTACT_ORDER = "link.contact_order";
    public static final String LINK_CONTACT_TYPE = "link.contact_type";
    public static final String CONTACT_ORDER = "contact_order";
    public static final String CONTACT_TYPE = "contact_type";

    public GenericOrganizationalUnitContactCollection(DataCollection dataCollection) {
        super(dataCollection);
        this.m_dataCollection.addOrder(LINK_CONTACT_ORDER);
    }

    public String getContactType() {
        return (String)this.m_dataCollection.get(LINK_CONTACT_TYPE);
    }

    public void setContactType(String contactType) {
        DataObject link = (DataObject)this.get("link");
        link.set(CONTACT_TYPE, (Object)contactType);
    }

    public Integer getContactOrder() {
        return (Integer)this.m_dataCollection.get(LINK_CONTACT_ORDER);
    }

    public void setContactOrder(Integer order) {
        DataObject link = (DataObject)this.get("link");
        link.set(CONTACT_ORDER, (Object)order);
    }

    public void swapWithNext(GenericContact contact) {
        int currentPos = 0;
        int currentIndex = 0;
        int nextIndex = 0;
        s_log.debug((Object)"Searching contact...");
        this.rewind();
        while (this.next()) {
            currentPos = this.getPosition();
            currentIndex = this.getContactOrder();
            s_log.debug((Object)String.format("Position: %d(%d)/%d", currentPos, currentIndex, this.size()));
            s_log.debug((Object)String.format("getContactOrder(): %d", this.getContactOrder()));
            if (!this.getContact().equals(contact)) continue;
        }
        if (currentPos == 0) {
            throw new IllegalArgumentException(String.format("The provided contact is not part of this collection.", new Object[0]));
        }
        if (!this.next()) {
            throw new IllegalArgumentException("The provided contact is the last in the collection, so there is no next object to swap with.");
        }
        nextIndex = this.getContactOrder();
        this.rewind();
        while (this.getPosition() != currentPos) {
            this.next();
        }
        this.setContactOrder(nextIndex);
        this.next();
        this.setContactOrder(currentIndex);
        this.rewind();
    }

    public void swapWithPrevious(GenericContact contact) {
        int previousPos = 0;
        int previousIndex = 0;
        int currentPos = 0;
        int currentIndex = 0;
        s_log.debug((Object)"Searching child...");
        this.rewind();
        while (this.next()) {
            currentPos = this.getPosition();
            currentIndex = this.getContactOrder();
            s_log.debug((Object)String.format("Position: %d(%d)/%d", currentPos, currentIndex, this.size()));
            s_log.debug((Object)String.format("getContactOrder(): %d", this.getContactOrder()));
            if (this.getContact().equals(contact)) break;
            previousPos = currentPos;
            previousIndex = currentIndex;
        }
        if (currentPos == 0) {
            throw new IllegalArgumentException(String.format("The provided contact is not part of this collection.", new Object[0]));
        }
        if (previousPos == 0) {
            throw new IllegalArgumentException(String.format("The provided contact is the first one in this collection, so there is no previous one to switch with.", new Object[0]));
        }
        this.rewind();
        while (this.getPosition() != previousPos) {
            this.next();
        }
        this.setContactOrder(currentIndex);
        this.next();
        this.setContactOrder(previousIndex);
        this.rewind();
    }

    public GenericContact getContact() {
        ContentBundle bundle = (ContentBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
        return (GenericContact)bundle.getInstance(GlobalizationHelper.getNegotiatedLocale().getLanguage());
    }

    public GenericContact getContact(String language) {
        ContentBundle bundle = (ContentBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
        return (GenericContact)bundle.getInstance(language);
    }

    public GenericPerson getPerson() {
        DataCollection collection = (DataCollection)this.m_dataCollection.getDataObject().get("person");
        if (collection.size() == 0L) {
            return null;
        }
        collection.next();
        DataObject dobj = collection.getDataObject();
        collection.close();
        GenericPersonBundle bundle = (GenericPersonBundle)DomainObjectFactory.newInstance((DataObject)dobj);
        return (GenericPerson)bundle.getPrimaryInstance();
    }

    public GenericAddress getAddress() {
        return this.getContact().getAddress();
    }

    public GenericContactEntryCollection getContactEntries() {
        return this.getContact().getContactEntries();
    }
}

