/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundle;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

public class GenericOrganizationalUnitSuperiorCollection
extends DomainCollection {
    public static final String ASSOCTYPE = "assocType";
    public static final String SUPERIOR_ORGAUNIT_ORDER = "superiorOrgaUnitOrder";
    public static final String LINK_ASSOCTYPE = "link.assocType";
    public static final String LINK_SUPERIOR_ORGAUNIT_ORDER = "link.superiorOrgaUnitOrder";

    public GenericOrganizationalUnitSuperiorCollection(DataCollection dataCollection) {
        super(dataCollection);
        this.m_dataCollection.addOrder("link.superiorOrgaUnitOrder asc");
    }

    public String getAssocType() {
        return (String)this.m_dataCollection.get(LINK_ASSOCTYPE);
    }

    public void setAssocType(String assocType) {
        DataObject link = (DataObject)this.get("link");
        link.set(ASSOCTYPE, (Object)assocType);
    }

    public Integer getSuperiorOrder() {
        return (Integer)this.m_dataCollection.get(LINK_SUPERIOR_ORGAUNIT_ORDER);
    }

    public void setSuperiorOrder(Integer order) {
        DataObject link = (DataObject)this.get("link");
        link.set(SUPERIOR_ORGAUNIT_ORDER, (Object)order);
    }

    public void swapWithNext(GenericOrganizationalUnit orgaunit) {
        if (orgaunit == null) {
            throw new IllegalArgumentException("Parameter orgaunit is null. Can't swap position with null");
        }
        int currentPos = 0;
        int currentIndex = 0;
        int nextIndex = 0;
        this.rewind();
        while (this.next()) {
            currentPos = this.getPosition();
            currentIndex = this.getSuperiorOrder();
            if (!orgaunit.equals(this.getGenericOrganizationalUnit())) continue;
        }
        if (!this.next()) {
            throw new IllegalArgumentException("The provided organizational unit is the last one in the collection, so there is no next object to swap with.");
        }
        nextIndex = this.getSuperiorOrder();
        this.rewind();
        while (this.getPosition() != currentPos) {
            this.next();
        }
        this.setSuperiorOrder(nextIndex);
        this.next();
        this.setSuperiorOrder(currentIndex);
        this.rewind();
        this.normalizeOrder();
    }

    public void swapWithPrevious(GenericOrganizationalUnit orgaunit) {
        if (orgaunit == null) {
            throw new IllegalArgumentException("Parameter orgaunit is null. Can't swap position with null");
        }
        int previousPos = 0;
        int previousIndex = 0;
        int currentPos = 0;
        int currentIndex = 0;
        this.rewind();
        while (this.next()) {
            currentPos = this.getPosition();
            currentIndex = this.getSuperiorOrder();
            if (orgaunit.equals(this.getGenericOrganizationalUnit())) break;
            previousPos = currentPos;
            previousIndex = currentIndex;
        }
        if (currentPos == 0) {
            throw new IllegalArgumentException("The provided contact is the first one in this collection, so there is no previous one to switch with.");
        }
        this.rewind();
        while (this.getPosition() != previousPos) {
            this.next();
        }
        this.setSuperiorOrder(currentIndex);
        this.next();
        this.setSuperiorOrder(previousIndex);
        this.rewind();
        this.normalizeOrder();
    }

    private void normalizeOrder() {
        this.rewind();
        int i = 1;
        while (this.next()) {
            this.setSuperiorOrder(i);
            ++i;
        }
        this.rewind();
    }

    public GenericOrganizationalUnitBundle getGenericOrganizationalUnitBundle() {
        return (GenericOrganizationalUnitBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
    }

    public GenericOrganizationalUnit getGenericOrganizationalUnit() {
        ContentBundle bundle = (ContentBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
        return (GenericOrganizationalUnit)bundle.getPrimaryInstance();
    }

    public GenericOrganizationalUnit getGenericOrganizationalUnit(String language) {
        ContentBundle bundle = (ContentBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
        return (GenericOrganizationalUnit)bundle.getInstance(language);
    }

    public OID getOID() {
        return this.m_dataCollection.getDataObject().getOID();
    }

    public String getName() {
        return (String)this.m_dataCollection.get("name");
    }

    public String getTitle() {
        return this.getGenericOrganizationalUnit().getTitle();
    }

    public String getAddendum() {
        return this.getGenericOrganizationalUnit().getAddendum();
    }
}

