/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.LanguageInvariantContentItem;
import com.arsdigita.cms.RelationAttributeInterface;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericPersonBundle;
import com.arsdigita.cms.contenttypes.GenericPersonContactCollection;
import com.arsdigita.cms.contenttypes.ui.GenericPersonExtraXmlGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class GenericPerson
extends ContentPage
implements RelationAttributeInterface,
LanguageInvariantContentItem {
    public static final String PERSON = "person";
    public static final String SURNAME = "surname";
    public static final String GIVENNAME = "givenname";
    public static final String TITLEPRE = "titlepre";
    public static final String TITLEPOST = "titlepost";
    public static final String BIRTHDATE = "birthdate";
    public static final String GENDER = "gender";
    public static final String CONTACTS = "contacts";
    public static final String CONTACTS_KEY = "linkKey";
    public static final String CONTACTS_ORDER = "linkOrder";
    public static final String ALIAS = "alias";
    public static final String DABIN_ID = "dabinId";
    private static final String RELATION_ATTRIBUTES = "contacts.link_key:GenericContactType";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericPerson";

    public GenericPerson() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public GenericPerson(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericPerson(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public GenericPerson(DataObject obj) {
        super(obj);
    }

    public GenericPerson(String type) {
        super(type);
    }

    public GenericPersonBundle getGenericPersonBundle() {
        return (GenericPersonBundle)this.getContentBundle();
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)((Object)this.getContentType()), ContentType.class);
    }

    public String getSurname() {
        return (String)this.get(SURNAME);
    }

    public void setSurname(String surname) {
        this.set(SURNAME, surname);
        this.updateNameAndTitle();
    }

    public String getGivenName() {
        return (String)this.get(GIVENNAME);
    }

    public void setGivenName(String givenName) {
        this.set(GIVENNAME, givenName);
        this.updateNameAndTitle();
    }

    public String getTitlePre() {
        return (String)this.get(TITLEPRE);
    }

    public void setTitlePre(String titlePre) {
        this.set(TITLEPRE, titlePre);
        this.updateNameAndTitle();
    }

    public String getTitlePost() {
        return (String)this.get(TITLEPOST);
    }

    public void setTitlePost(String titlePost) {
        this.set(TITLEPOST, titlePost);
        this.updateNameAndTitle();
    }

    public Date getBirthdate() {
        return (Date)this.get(BIRTHDATE);
    }

    public void setBirthdate(Date birthdate) {
        this.set(BIRTHDATE, birthdate);
    }

    public String getGender() {
        return (String)this.get(GENDER);
    }

    public void setGender(String gender) {
        this.set(GENDER, gender);
    }

    public GenericPerson getAlias() {
        return (GenericPerson)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(ALIAS)));
    }

    public void setAlias(GenericPerson alias) {
        this.set(ALIAS, alias);
    }

    public void unsetAlias() {
        this.set(ALIAS, null);
    }

    public Integer getDabinId() {
        return (Integer)this.get(DABIN_ID);
    }

    public void setDabinId(Integer dabinId) {
        this.set(DABIN_ID, dabinId);
    }

    public String getFullName() {
        String titlePre = this.getTitlePre();
        String givenName = this.getGivenName();
        String surname = this.getSurname();
        String titlePost = this.getTitlePost();
        if (titlePre == null) {
            titlePre = "";
        }
        if (titlePost == null) {
            titlePost = "";
        }
        if (givenName == null) {
            givenName = "";
        }
        if (surname == null) {
            surname = "";
        }
        if (titlePost.trim().isEmpty()) {
            return String.format("%s %s %s", titlePre, givenName, surname).trim();
        }
        return String.format("%s %s %s, %s", titlePre, givenName, surname, titlePost).trim();
    }

    private void updateNameAndTitle() {
        String fullname = this.getFullName();
        if (fullname != null && !fullname.isEmpty()) {
            this.setTitle(fullname);
            this.setName(GenericPerson.urlSave(String.format("%s %s", this.getSurname(), this.getGivenName())));
        }
    }

    public GenericPersonContactCollection getContacts() {
        return this.getGenericPersonBundle().getContacts();
    }

    public void addContact(GenericContact contact, String contactType) {
        this.getGenericPersonBundle().addContact(contact, contactType);
    }

    public void removeContact(GenericContact contact) {
        this.getGenericPersonBundle().removeContact(contact);
    }

    public boolean hasContacts() {
        return !this.getContacts().isEmpty();
    }

    public static String urlSave(String in) {
        if (in != null && !in.isEmpty()) {
            String[][] replacements = new String[][]{{"\u00e4", "ae"}, {"\u00c4", "Ae"}, {"\u00f6", "oe"}, {"\u00d6", "Oe"}, {"\u00fc", "ue"}, {"\u00dc", "Ue"}, {"\u00df", "ss"}, {".", ""}};
            String out = in.replace(" ", "-");
            for (int i = 0; i < replacements.length; ++i) {
                out = out.replace(replacements[i][0], replacements[i][1]);
            }
            return out.replaceAll("[^A-Za-z0-9-]", "_").toLowerCase();
        }
        return in;
    }

    @Override
    public boolean hasRelationAttributes() {
        return !RELATION_ATTRIBUTES.isEmpty();
    }

    @Override
    public boolean hasRelationAttributeProperty(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringTokenizer getRelationAttributes() {
        return new StringTokenizer(RELATION_ATTRIBUTES, ";");
    }

    @Override
    public String getRelationAttributeKeyName(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return token.substring(token.indexOf(".") + 1, token.indexOf(":"));
        }
        return null;
    }

    @Override
    public String getRelationAttributeName(String propertyName) {
        StringTokenizer strTok = new StringTokenizer(RELATION_ATTRIBUTES, ";");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.startsWith(propertyName + ".")) continue;
            return token.substring(token.indexOf(":") + 1);
        }
        return null;
    }

    @Override
    public String getRelationAttributeKey(String propertyName) {
        return null;
    }

    @Override
    public String getSearchSummary() {
        return this.getFullName();
    }

    @Override
    public boolean isLanguageInvariant() {
        return true;
    }

    @Override
    public List<ExtraXMLGenerator> getExtraXMLGenerators() {
        List<ExtraXMLGenerator> generators = super.getExtraListXMLGenerators();
        generators.add(new GenericPersonExtraXmlGenerator());
        return generators;
    }

    @Override
    public List<ExtraXMLGenerator> getExtraListXMLGenerators() {
        List<ExtraXMLGenerator> generators = super.getExtraListXMLGenerators();
        generators.add(new GenericPersonExtraXmlGenerator());
        return generators;
    }
}

