/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactBundle;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundle;
import com.arsdigita.cms.contenttypes.GenericPersonContactCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class GenericPersonBundle
extends ContentBundle {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.GenericPersonBundle";
    public static final String CONTACTS = "contacts";
    public static final String CONTACTS_KEY = "linkKey";
    public static final String CONTACTS_ORDER = "linkOrder";

    public GenericPersonBundle(ContentItem primary) {
        super(BASE_DATA_OBJECT_TYPE);
        Assert.exists((Object)primary, ContentItem.class);
        this.setDefaultLanguage(primary.getLanguage());
        this.setContentType(primary.getContentType());
        this.addInstance(primary);
        super.setName(primary.getName());
    }

    public GenericPersonBundle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public GenericPersonBundle(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public GenericPersonBundle(DataObject dobj) {
        super(dobj);
    }

    public GenericPersonBundle(String type) {
        super(type);
    }

    public GenericPersonContactCollection getContacts() {
        return new GenericPersonContactCollection((DataCollection)this.get(CONTACTS));
    }

    public void addContact(GenericContact contact, String contactType) {
        Assert.exists((Object)contact, GenericContact.class);
        DataObject link = this.add(CONTACTS, (DomainObject)contact.getContentBundle());
        link.set(CONTACTS_KEY, (Object)contactType);
        link.set(CONTACTS_ORDER, (Object)BigDecimal.valueOf(this.getContacts().size()));
    }

    public void removeContact(GenericContact contact) {
        Assert.exists((Object)contact, GenericContact.class);
        this.remove(CONTACTS, (DomainObject)contact.getContentBundle());
    }

    public boolean hasContacts() {
        return !this.getContacts().isEmpty();
    }

    @Override
    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        String attribute = property.getName();
        GenericPersonBundle personBundle = (GenericPersonBundle)source;
        if (copier.getCopyType() == 1) {
            if (CONTACTS.equals(attribute)) {
                DataCollection contacts = (DataCollection)personBundle.get(CONTACTS);
                while (contacts.next()) {
                    this.createContactAssoc(contacts);
                }
                return true;
            }
            if ("organizationalunit".equals(attribute)) {
                DataCollection orgaunits = (DataCollection)personBundle.get("organizationalunit");
                while (orgaunits.next()) {
                    this.createOrgaUnitAssoc(orgaunits);
                }
                return true;
            }
            return super.copyProperty(source, property, copier);
        }
        return super.copyProperty(source, property, copier);
    }

    private void createContactAssoc(DataCollection contacts) {
        GenericContactBundle draftContact = (GenericContactBundle)DomainObjectFactory.newInstance((DataObject)contacts.getDataObject());
        GenericContactBundle liveContact = (GenericContactBundle)draftContact.getLiveVersion();
        if (liveContact != null) {
            DataObject link = this.add(CONTACTS, (DomainObject)liveContact);
            link.set(CONTACTS_KEY, contacts.get("link.linkKey"));
            link.set(CONTACTS_ORDER, contacts.get("link.linkOrder"));
            link.save();
        }
    }

    private void createOrgaUnitAssoc(DataCollection orgaunits) {
        GenericOrganizationalUnitBundle draftOrga = (GenericOrganizationalUnitBundle)DomainObjectFactory.newInstance((DataObject)orgaunits.getDataObject());
        GenericOrganizationalUnitBundle liveOrga = (GenericOrganizationalUnitBundle)draftOrga.getLiveVersion();
        if (liveOrga != null) {
            DataObject link = this.add("organizatialunit", (DomainObject)liveOrga);
            link.set("role_name", orgaunits.get("link.role_name"));
            link.set("status", orgaunits.get("link.status"));
            link.save();
        }
    }
}

