/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactBundle;
import com.arsdigita.cms.contenttypes.GenericContactEntryCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import java.math.BigDecimal;

public class GenericPersonContactCollection
extends DomainCollection {
    public static final String ORDER = "link.linkOrder asc";
    public static final String CONTACTS_KEY = "link.linkKey";
    public static final String CONTACTS_ORDER = "link.linkOrder";

    public GenericPersonContactCollection(DataCollection dataCollection) {
        super(dataCollection);
        this.m_dataCollection.addOrder(ORDER);
    }

    public String getContactType() {
        return (String)this.m_dataCollection.get(CONTACTS_KEY);
    }

    public String getContactOrder() {
        String retVal = ((BigDecimal)this.m_dataCollection.get(CONTACTS_ORDER)).toString();
        if (retVal == null || retVal.isEmpty()) {
            retVal = String.valueOf(this.getPosition());
        }
        return retVal;
    }

    public void setContactOrder(BigDecimal order) {
        DataObject link = (DataObject)this.get("link");
        link.set("linkOrder", (Object)order);
    }

    public void swapWithNext(GenericContact contact) {
        int currentPos = 0;
        int currentIndex = 0;
        int nextIndex = 0;
        this.rewind();
        while (this.next()) {
            currentPos = this.getPosition();
            currentIndex = Integer.parseInt(this.getContactOrder());
            if (!this.getContact().equals(contact)) continue;
        }
        if (currentPos == 0) {
            throw new IllegalArgumentException(String.format("The provided contact is not part of this collection.", new Object[0]));
        }
        if (!this.next()) {
            throw new IllegalArgumentException("The provided contact is the last in the collection, so there is no next object to swap with.");
        }
        nextIndex = Integer.parseInt(this.getContactOrder());
        this.rewind();
        while (this.getPosition() != currentPos) {
            this.next();
        }
        this.setContactOrder(new BigDecimal(nextIndex));
        this.next();
        this.setContactOrder(new BigDecimal(currentIndex));
        this.rewind();
    }

    public void swapWithPrevious(GenericContact contact) {
        int previousPos = 0;
        int previousIndex = 0;
        int currentPos = 0;
        int currentIndex = 0;
        this.rewind();
        while (this.next()) {
            currentPos = this.getPosition();
            currentIndex = Integer.parseInt(this.getContactOrder());
            if (this.getContact().equals(contact)) break;
            previousPos = currentPos;
            previousIndex = currentIndex;
        }
        if (currentPos == 0) {
            throw new IllegalArgumentException(String.format("The provided contact is not part of this collection.", new Object[0]));
        }
        if (previousPos == 0) {
            throw new IllegalArgumentException(String.format("The provided contact is the first one in this collection, so there is no previous one to switch with.", new Object[0]));
        }
        this.rewind();
        while (this.getPosition() != previousPos) {
            this.next();
        }
        this.setContactOrder(new BigDecimal(currentIndex));
        this.next();
        this.setContactOrder(new BigDecimal(previousIndex));
        this.rewind();
    }

    public GenericContact getContact() {
        GenericContactBundle bundle = (GenericContactBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
        return (GenericContact)bundle.getInstance(GlobalizationHelper.getNegotiatedLocale().getLanguage());
    }

    public GenericContact getContact(String language) {
        GenericContactBundle bundle = (GenericContactBundle)DomainObjectFactory.newInstance((DataObject)this.m_dataCollection.getDataObject());
        return (GenericContact)bundle.getInstance(language);
    }

    public GenericPerson getPerson() {
        DataCollection collection = (DataCollection)this.m_dataCollection.getDataObject().get("person");
        if (collection.size() == 0L) {
            return null;
        }
        collection.next();
        DataObject dobj = collection.getDataObject();
        collection.close();
        GenericContactBundle bundle = (GenericContactBundle)DomainObjectFactory.newInstance((DataObject)dobj);
        return (GenericPerson)bundle.getPrimaryInstance();
    }

    public GenericAddress getAddress() {
        return this.getContact().getAddress();
    }

    public GenericContactEntryCollection getContactEntries() {
        return this.getContact().getContactEntries();
    }
}

