/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.contenttypes.ContentTypeHelper;
import com.arsdigita.cms.contenttypes.ContentTypeHelperImpl;
import com.arsdigita.cms.ui.authoring.PageCreateDynamic;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.Model;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class UDCTHelper
extends ContentTypeHelperImpl
implements ContentTypeHelper {
    private static final Logger s_log = Logger.getLogger(UDCTHelper.class);
    private static final String CATEGORIZATION_COMPONENT = "com.arsdigita.cms.ui.authoring.ItemCategoryStep";
    private static final String CREATION_COMPONENT = PageCreateDynamic.class.getName();
    private String m_parent;
    private ObjectType m_parentType;
    private ContentType m_type;
    private String m_name;
    private int m_stepCount = 1;
    private boolean m_hasCategoryStep = false;

    public UDCTHelper() {
        this.setCreateComponent(CREATION_COMPONENT);
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void setParentType(String parentType) {
        this.m_parent = parentType;
        this.m_parentType = SessionManager.getMetadataRoot().getObjectType(parentType);
    }

    public ObjectType getParentType() {
        return this.m_parentType;
    }

    public ContentType getParentContentType() throws UncheckedWrapperException {
        try {
            ContentType parent = ContentType.findByAssociatedObjectType(this.m_parent);
            return parent;
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException("Parent Type not found", (Throwable)e);
        }
    }

    @Override
    public AuthoringKit createAuthoringKit() {
        this.setCreateComponent(CREATION_COMPONENT);
        AuthoringKit kit = super.createAuthoringKit();
        this.addParentSteps();
        kit.save();
        return kit;
    }

    private DynamicObjectType createDOT() {
        DynamicObjectType dot = new DynamicObjectType(this.m_name, this.m_parentType);
        dot.save();
        return dot;
    }

    @Override
    public ContentType createType() {
        ObjectType obj;
        MetadataRoot root = SessionManager.getMetadataRoot();
        Model m = root.getModel(this.m_name);
        Perl5Util re = new Perl5Util();
        int lastPeriod = this.m_parent.lastIndexOf(".");
        String modelName = this.m_parent.substring(0, lastPeriod);
        s_log.debug((Object)("ModelName is : " + modelName));
        m = root.getModel(modelName);
        if (m != null) {
            s_log.debug((Object)("Model is : " + m.getName()));
            obj = m.getObjectType(this.m_name);
            if (obj == null) {
                obj = this.createDOT().getObjectType();
            }
        } else {
            s_log.debug((Object)"No model");
            obj = this.createDOT().getObjectType();
        }
        s_log.debug((Object)("Dynamic object: " + obj.getQualifiedName()));
        this.setObjectType(obj.getQualifiedName());
        this.m_type = super.createType();
        this.m_type.setID();
        PersistentForm pForm = PersistentForm.create((String)(this.m_name + "ItemForm"));
        pForm.save();
        this.m_type.setItemFormID(pForm.getID());
        this.m_type.save();
        return this.m_type;
    }

    public void addParentSteps() {
        AuthoringStepCollection parentSteps = this.getParentContentType().getAuthoringKit().getSteps();
        AuthoringKit kit = this.getAuthoringKit();
        s_log.debug((Object)"loading parent authoring steps");
        while (parentSteps.next()) {
            AuthoringStep step = parentSteps.getAuthoringStep();
            if (CATEGORIZATION_COMPONENT.equals(step.getComponent())) {
                this.m_hasCategoryStep = true;
            }
            kit.createStep(step.getLabel(), step.getDescription(), step.getComponent(), new BigDecimal(this.m_stepCount));
            ++this.m_stepCount;
        }
        kit.save();
        this.m_type.save();
    }

    @Override
    public void addAuthoringStep(String label, String description, String component, BigDecimal ordering) {
        ordering.add(new BigDecimal(new Integer(this.m_stepCount).toString()));
        super.addAuthoringStep(label, description, component, ordering);
    }
}

