/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.contenttypes.ContentTypeHelper;
import com.arsdigita.cms.contenttypes.ContentTypeHelperImpl;
import com.arsdigita.cms.contenttypes.UDCTHelper;
import com.arsdigita.xml.XML;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentTypeHandler
extends DefaultHandler {
    private static Logger s_log = Logger.getLogger((String)XMLContentTypeHandler.class.getName());
    private ArrayList m_types = new ArrayList();
    private ContentTypeHelper m_type;
    private ContentType m_contentType;
    private AuthoringKit m_authoringKit;
    private int m_nextOrder;
    private boolean m_including;

    public List getContentTypes() {
        return this.m_types;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals("content-types")) {
            s_log.debug((Object)"matched content-types");
        } else if (name.equals("content-type")) {
            s_log.debug((Object)"matched content-type");
            String parentType = atts.getValue("parentType");
            if (parentType != null) {
                this.m_type = new UDCTHelper();
                s_log.debug((Object)"Creating UDCT");
            } else {
                this.m_type = new ContentTypeHelperImpl();
                s_log.debug((Object)"Creating regular content type");
            }
            this.m_type.setLabel(atts.getValue("label"));
            this.m_type.setLabelBundle(atts.getValue("labelBundle"));
            this.m_type.setLabelKey(atts.getValue("labelKey"));
            this.m_type.setDescription(atts.getValue("description"));
            this.m_type.setDescriptionBundle(atts.getValue("descriptionBundle"));
            this.m_type.setDescriptionKey(atts.getValue("descriptionKey"));
            this.m_type.setObjectType(atts.getValue("objectType"));
            this.m_type.setClassName(atts.getValue("classname"));
            String mode = atts.getValue("mode");
            if (mode != null && !mode.isEmpty()) {
                this.m_type.setMode(mode.trim());
            } else {
                this.m_type.setMode("default");
            }
            this.m_type.setParentType(parentType);
            this.m_type.setName(atts.getValue("name"));
            this.m_contentType = this.m_type.createType();
            this.m_types.add(this.m_contentType);
        } else if (name.equals("authoring-kit")) {
            if (!this.m_including) {
                s_log.debug((Object)"matched authoring-kit");
                if (atts.getValue("createComponent") != null) {
                    this.m_type.setCreateComponent(atts.getValue("createComponent"));
                }
                this.m_authoringKit = this.m_type.createAuthoringKit();
                this.m_nextOrder = 1;
            }
        } else if (name.equals("authoring-step")) {
            String label = atts.getValue("label");
            String labelKey = atts.getValue("labelKey");
            String labelBundle = atts.getValue("labelBundle");
            String description = atts.getValue("description");
            String descriptionKey = atts.getValue("descriptionKey");
            String descriptionBundle = atts.getValue("descriptionBundle");
            if (labelKey == null) {
                labelKey = label;
            }
            if (descriptionKey == null) {
                descriptionKey = description;
            }
            this.m_type.addAuthoringStep(labelKey, labelBundle, descriptionKey, descriptionBundle, atts.getValue("component"), new BigDecimal(this.m_nextOrder++));
        } else if (name.equals("include")) {
            String file = atts.getValue("href");
            this.m_including = true;
            XML.parseResource((String)file, (DefaultHandler)this);
            this.m_including = false;
        } else {
            s_log.error((Object)("None of the elements match! name: " + name + " qName: " + qName + " URI: " + uri));
        }
    }

    public void endElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals("content-type")) {
            this.m_contentType.save();
            this.m_authoringKit.save();
            this.m_type.saveType();
            this.m_type = null;
        }
    }
}

