/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.MimeTypeStatus;
import com.arsdigita.mimetypes.TextMimeType;
import com.arsdigita.mimetypes.converters.ConvertFormat;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractTextUploadForm
extends Form
implements FormInitListener,
FormProcessListener,
FormValidationListener {
    private ItemSelectionModel m_itemModel;
    private FileUploadSection m_fileUploadSection;
    private SaveCancelSection m_saveCancelSection;
    private RequestLocal m_fileUploadContent;
    private RequestLocal m_fileUploadContentUsedInso;
    private Logger s_log = Logger.getLogger(AbstractTextUploadForm.class);

    public AbstractTextUploadForm(ItemSelectionModel itemModel) {
        super("sciprojectUploadDescFrom", (Container)new BoxPanel(2));
        this.m_itemModel = itemModel;
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        this.m_fileUploadContent = new RequestLocal();
        this.m_fileUploadContentUsedInso = new RequestLocal();
        this.addWidgets();
    }

    public abstract GlobalizedMessage getLabelText();

    public abstract GlobalizedMessage getMimeTypeLabel();

    public abstract void setText(ItemSelectionModel var1, PageState var2, String var3);

    protected void addWidgets() {
        this.add((Component)new Label(this.getLabelText()));
        this.m_fileUploadSection = new FileUploadSection(this.getMimeTypeLabel(), "mime", "text/plain");
        this.m_fileUploadSection.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_fileUploadSection.getMimeTypeWidget().setDefaultValue((Object)"-guess-");
        this.add((Component)this.m_fileUploadSection);
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection);
        this.add((Component)new FormErrorDisplay((Form)this));
        this.addValidationListener(this);
        this.addProcessListener(this);
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    public void init(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        this.setVisible(state, true);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        MimeType mime = this.m_fileUploadSection.getMimeType(e);
        boolean textType = mime.getPrefix().equals("text");
        this.validateFileType(mime, textType);
        File file = this.m_fileUploadSection.getFile(e);
        byte[] file_bytes = this.readFileBytes(file);
        boolean[] used_inso = new boolean[1];
        String file_content = this.convertBytes(file_bytes, textType, used_inso);
        if ("text/html".equals(mime.getMimeType())) {
            file_content = this.extractHTMLBody(file_content);
        }
        PageState state = e.getPageState();
        this.m_fileUploadContent.set(state, (Object)file_content);
        this.m_fileUploadContentUsedInso.set(state, (Object)used_inso[0]);
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        this.s_log.debug((Object)"Processing upload...");
        PageState state = fse.getPageState();
        String uploadContent = (String)this.m_fileUploadContent.get(state);
        this.s_log.debug((Object)String.format("Setting project description to: %s", uploadContent));
        this.s_log.debug((Object)"Saving project.");
        this.setText(this.m_itemModel, state, uploadContent);
    }

    private void validateFileType(MimeType mime, boolean textType) throws FormProcessException {
        boolean insoWorks;
        boolean validType;
        boolean bl = validType = textType || mime instanceof TextMimeType && ((TextMimeType)mime).allowINSOConvert() != false;
        if (!validType) {
            throw new FormProcessException("Cannot load files of type " + mime.getMimeType() + " into the article body.");
        }
        boolean bl2 = insoWorks = MimeTypeStatus.getMimeTypeStatus().getInsoFilterWorks().intValue() == 1;
        if (!textType && !insoWorks) {
            throw new FormProcessException("Could not convert to html format because interMedia INSO filter is not installed.");
        }
    }

    private byte[] readFileBytes(File file) throws FormProcessException {
        byte[] file_bytes;
        try {
            FileInputStream fs = new FileInputStream(file);
            file_bytes = new byte[fs.available()];
            fs.read(file_bytes);
            fs.close();
        }
        catch (Exception e) {
            throw new FormProcessException(((String)GlobalizationUtil.globalize((String)"cms.ui.authoring.unable_to_load_file").localize()).concat(e.getMessage()));
        }
        return file_bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertBytes(byte[] file_bytes, boolean text_type, boolean[] used_inso) throws FormProcessException {
        String file_content;
        if (!text_type) {
            file_content = ConvertFormat.toHTML((byte[])file_bytes);
            if (file_content == null) throw new FormProcessException("Could not convert to html format. interMedia INSO filter conversion failed.");
            used_inso[0] = true;
            return file_content;
        }
        String enc = Globalization.getDefaultCharset((Locale)Kernel.getContext().getLocale());
        try {
            file_content = new String(file_bytes, enc);
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedWrapperException("cannot convert to encoding " + enc, (Throwable)ex);
        }
        used_inso[0] = false;
        return file_content;
    }

    private String extractHTMLBody(String htmlText) throws FormProcessException {
        String lc = htmlText.toLowerCase();
        int bodyStart = lc.indexOf("<body");
        int bodyStart_v = lc.indexOf(">", bodyStart);
        int bodyEnd = lc.indexOf("</body>", bodyStart_v);
        if (bodyStart == -1 || bodyEnd == -1) {
            String errMsg = "The file (which should be type HTML) is missing the <body> or </body> tag.";
            throw new FormProcessException("The file (which should be type HTML) is missing the <body> or </body> tag.");
        }
        return htmlText.substring(bodyStart_v + 1, bodyEnd);
    }
}

