/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CMSContext;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class CompoundContentItemPanel
extends SimpleComponent
implements ExtraXMLGenerator {
    private static final Logger s_log = Logger.getLogger(CompoundContentItemPanel.class);
    private ContentItem m_item = null;
    private static final String SHOW_PARAM = "show";
    protected StringParameter m_show = new StringParameter("show");
    private String showDefault;
    private boolean showOnlyDefault = false;
    private static final String PAGE_NUMBER = "pageNumber";
    protected IntegerParameter m_pageNumber = new IntegerParameter("pageNumber");
    private long m_pageSize = 30L;

    public void register(Page p) {
        super.register(p);
        this.addGlobalStateParams(p);
    }

    @Override
    public void addGlobalStateParams(Page p) {
        p.addGlobalStateParam((ParameterModel)this.m_show);
        p.addGlobalStateParam((ParameterModel)this.m_pageNumber);
    }

    protected XMLGenerator getXMLGenerator(PageState state, ContentItem item) {
        ContentSection section = null;
        try {
            section = CMS.getContext().getContentSection();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (section == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Item id ; " + item.getOID() + " - " + (Object)((Object)item.getContentSection()) + " - " + item));
            }
            section = item.getContentSection();
            CMS.getContext().setContentSection(section);
        }
        return section.getXMLGenerator();
    }

    protected ContentItem getContentItem(PageState state) {
        if (this.m_item == null) {
            CMSContext context = CMS.getContext();
            if (!context.hasContentItem()) {
                return null;
            }
            return context.getContentItem().getLiveVersion();
        }
        return this.m_item;
    }

    public void setContentItem(ContentItem item) {
        if (item instanceof ContentBundle) {
            ContentItem resolved = null;
            ContentBundle bundle = (ContentBundle)item;
            resolved = bundle.getInstance(GlobalizationHelper.getNegotiatedLocale().getLanguage());
            if (resolved == null) {
                resolved = bundle.getPrimaryInstance();
            }
            this.m_item = resolved.getLiveVersion();
        } else {
            this.m_item = item;
        }
    }

    public long getPageSize() {
        return this.m_pageSize;
    }

    public void setPageSize(long pageSize) {
        this.m_pageSize = pageSize;
    }

    protected long getPageCount(long objectCount) {
        return (long)Math.ceil((double)objectCount / (double)this.m_pageSize);
    }

    protected long normalizePageNumber(long pageCount, long pageNumber) {
        long num = pageNumber;
        if (num < 1L) {
            num = 1L;
        }
        if (num > pageCount) {
            num = pageCount == 0L ? 1L : pageCount;
        }
        return num;
    }

    protected long getPaginatorBegin(long pageNumber) {
        return (pageNumber - 1L) * this.m_pageSize;
    }

    protected long getPaginatorCount(long begin, long objectCount) {
        return Math.min(this.m_pageSize, objectCount - begin);
    }

    protected long getPaginatorEnd(long begin, long count) {
        long paginatorEnd = begin + count;
        if (paginatorEnd < 0L) {
            paginatorEnd = 0L;
        }
        return paginatorEnd;
    }

    protected void createPaginatorElement(Element parent, long pageNumber, long pageCount, long begin, long end, long count, long size) {
        Element paginator = parent.newChildElement("nav:paginator", "http://ccm.redhat.com/navigation");
        URL requestURL = Web.getContext().getRequestURL();
        ParameterMap map = new ParameterMap();
        if (requestURL.getParameterMap() != null) {
            for (String key : requestURL.getParameterMap().keySet()) {
                if (key.equals(PAGE_NUMBER)) continue;
                map.setParameterValues(key, requestURL.getParameterValues(key));
            }
        }
        paginator.addAttribute("pageParam", PAGE_NUMBER);
        paginator.addAttribute("baseURL", URL.there((String)requestURL.getPathInfo(), (ParameterMap)map).toString());
        paginator.addAttribute(PAGE_NUMBER, Long.toString(pageNumber));
        paginator.addAttribute("pageCount", Long.toString(pageCount));
        paginator.addAttribute("pageSize", Long.toString(this.m_pageSize));
        paginator.addAttribute("objectBegin", Long.toString(begin + 1L));
        paginator.addAttribute("objectEnd", Long.toString(end));
        paginator.addAttribute("objectCount", Long.toString(size));
    }

    protected final String getDefaultForShowParam() {
        if (this.showDefault == null || this.showDefault.isEmpty()) {
            return this.getDefaultShowParam();
        }
        return this.showDefault;
    }

    public void setDefaultForShowParam(String showDefault) {
        this.showDefault = showDefault;
    }

    protected abstract String getDefaultShowParam();

    public boolean isShowOnlyDefault() {
        return this.showOnlyDefault;
    }

    public void setShowOnlyDefault(boolean showOnlyDefault) {
        this.showOnlyDefault = showOnlyDefault;
    }

    protected String getShowParam(PageState state) {
        String show;
        try {
            show = (String)state.getValue((ParameterModel)this.m_show);
        }
        catch (IllegalArgumentException ex) {
            String value = state.getRequest().getParameter(SHOW_PARAM);
            if (value == null) {
                value = this.getDefaultForShowParam();
            }
            show = value;
            state.setValue((ParameterModel)this.m_show, (Object)value);
        }
        if (show == null) {
            show = this.getDefaultForShowParam();
        }
        return show;
    }

    protected String getHttpParam(String param, PageState state) {
        HttpServletRequest request = state.getRequest();
        String value = request.getParameter(param);
        return value;
    }

    protected long getPageNumber(PageState state) {
        int pageNumber;
        block5: {
            pageNumber = 1;
            s_log.info((Object)"Checking page state...");
            if (state == null) {
                s_log.warn((Object)"PageState is null!!!");
            }
            try {
                Object value = state.getValue((ParameterModel)this.m_pageNumber);
                pageNumber = value == null ? 1 : (Integer)value;
            }
            catch (IllegalArgumentException ex) {
                String value = state.getRequest().getParameter(PAGE_NUMBER);
                if (value == null) break block5;
                try {
                    pageNumber = Integer.parseInt(value);
                }
                catch (NumberFormatException ex1) {
                    s_log.warn((Object)"Invalid page number");
                }
                state.setValue((ParameterModel)this.m_pageNumber, (Object)pageNumber);
            }
        }
        return pageNumber;
    }

    protected abstract Class<? extends ContentItem> getAllowedClass();

    protected String getPanelName() {
        return this.getAllowedClass().getSimpleName();
    }

    protected Element generateBaseXML(ContentItem item, Element parent, PageState state) {
        Element content = parent.newChildElement(String.format("cms:%sData", this.getPanelName()), "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(content);
        content.addAttribute("showing", this.getShowParam(state));
        return content;
    }

    public void generateXML(PageState state, Element parent) {
        ContentItem item = this.getContentItem(state);
        boolean isVisible = this.isVisible(state);
        Class<? extends ContentItem> klass = this.getAllowedClass();
        if (!this.isVisible(state) || item == null || !item.getClass().equals(this.getAllowedClass())) {
            s_log.warn((Object)("Skipping generate XML isVisible: " + this.isVisible(state) + " item " + (item == null ? null : item.getOID())));
            return;
        }
        if (state == null) {
            s_log.warn((Object)"No page state provided!");
        }
        this.generateXML(item, parent, state);
    }
}

