/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.ContentGroup;
import com.arsdigita.cms.contenttypes.ContentGroupContainer;
import com.arsdigita.cms.ui.ItemListModel;
import com.arsdigita.cms.ui.SortableList;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class ContentGroupItemList
extends SortableList {
    private static final Logger s_log = Logger.getLogger(ContentGroupItemList.class);
    public static final String SUB_ITEM = "sub";
    protected String m_attributeName;
    private final ACSObjectSelectionModel m_model;

    public ContentGroupItemList(final ACSObjectSelectionModel model, String attributeName) {
        super(new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(SUB_ITEM)));
        this.m_model = model;
        this.m_attributeName = attributeName;
        this.setIdAttr("group_list");
        this.setModelBuilder(new ItemListModelBuilder(model));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                String id = (String)ContentGroupItemList.this.getSelectedKey(state);
                if (id != null) {
                    model.setSelectedKey(state, (Object)id);
                }
            }
        });
        Label l = new Label(GlobalizationUtil.globalize("no_items"));
        l.setFontWeight("i");
        this.setEmptyView((Component)l);
    }

    public void respond(PageState ps) throws ServletException {
        String event = ps.getControlEventName();
        if ("next".equals(event) || "prev".equals(event)) {
            try {
                ContentItem contentItem = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)new BigDecimal(ps.getControlEventValue())));
                ContentGroupContainer item = (ContentGroupContainer)this.m_model.getSelectedObject(ps);
                ContentGroup group = item.getContentGroup(this.m_attributeName);
                if ("next".equals(event)) {
                    group.swapWithNext(contentItem);
                } else {
                    group.swapWithPrevious(contentItem);
                }
            }
            catch (DataObjectNotFoundException exception) {
                s_log.error((Object)("Trying to create groups with state = " + ps), (Throwable)exception);
                throw new ServletException((Throwable)exception);
            }
        }
    }

    @Override
    protected void generateLabelXML(PageState state, Element parent, Label label, String key) {
        ExternalLink link = new ExternalLink((Component)label, URL.there((HttpServletRequest)state.getRequest(), (String)"/content-center/searchredirect", (ParameterMap)ParameterMap.fromString((String)("item_id=" + key + "&context=draft"))).toString());
        link.generateXML(state, parent);
    }

    private class ItemListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        ACSObjectSelectionModel m_model;

        public ItemListModelBuilder(ACSObjectSelectionModel model) {
            this.m_model = model;
        }

        public ListModel makeModel(List l, PageState state) {
            ContentGroupContainer item = (ContentGroupContainer)this.m_model.getSelectedObject(state);
            ContentGroup group = item.getContentGroup(ContentGroupItemList.this.m_attributeName);
            if (group == null) {
                return List.EMPTY_MODEL;
            }
            return new ItemListModel(group.getContentItems());
        }
    }
}

