/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.ContentGroup;
import com.arsdigita.cms.contenttypes.ContentGroupContainer;
import com.arsdigita.cms.contenttypes.ui.ContentGroupItemList;
import com.arsdigita.cms.contenttypes.ui.ContentGroupPropertyForm;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.util.GlobalizationUtil;
import org.apache.log4j.Logger;

public abstract class ContentGroupPropertiesStep
extends SimpleEditStep {
    private static final Logger s_log = Logger.getLogger(ContentGroupPropertiesStep.class);
    public static String EDIT_SHEET_NAME = "edit";

    public ContentGroupPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        ContentGroupPropertyForm editSheet = this.getPropertyForm(itemModel);
        this.add(EDIT_SHEET_NAME, "Edit", editSheet, editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(this.getPropertySheet(itemModel));
    }

    public Component getPropertySheet(ItemSelectionModel itemModel) {
        GridPanel panel = new GridPanel(2);
        panel.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.content_group_name")));
        panel.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label label = (Label)e.getTarget();
                ContentGroupContainer item = (ContentGroupContainer)ContentGroupPropertiesStep.this.getItemSelectionModel().getSelectedObject(e.getPageState());
                ContentGroup group = item.getContentGroup(ContentGroupPropertiesStep.this.getMainAttributeName());
                if (group == null) {
                    label.setLabel("None", e.getPageState());
                    label.setFontWeight("i");
                } else {
                    label.setLabel(group.getName(), e.getPageState());
                }
            }
        }));
        panel.add((Component)new ContentGroupItemList(this.getItemSelectionModel(), this.getMainAttributeName()), 64);
        return panel;
    }

    public abstract String getMainAttributeName();

    protected ContentGroupPropertyForm getPropertyForm(ItemSelectionModel itemModel) {
        return new ContentGroupPropertyForm(itemModel, this.getMainAttributeName());
    }
}

