/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.ContentGroup;
import com.arsdigita.cms.contenttypes.ContentGroupContainer;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ContentGroupPropertyForm
extends BasicItemForm {
    private static final Logger s_log = Logger.getLogger(ContentGroupPropertyForm.class);
    public static final String ASSOCIATED_ITEMS = "associatedItems";
    public static final String RELATED_ITEM = "relatedItem";
    private String m_attributeName;
    private CheckboxGroup m_checkboxGroup;

    public ContentGroupPropertyForm(ItemSelectionModel itemModel, String attributeName) {
        super("contentGroupProperty", itemModel);
        this.m_attributeName = attributeName;
    }

    @Override
    protected void addWidgets() {
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.content_group_name")));
        TextField nameWidget = new TextField((ParameterModel)new TrimmedStringParameter("name"));
        nameWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)nameWidget);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.content_group_current_items")){

            public boolean isVisible(PageState state) {
                ContentGroupContainer item = (ContentGroupContainer)ContentGroupPropertyForm.this.getItemSelectionModel().getSelectedObject(state);
                ContentGroup group = ContentGroupPropertyForm.this.getCurrentGroup(item, ContentGroupPropertyForm.this.m_attributeName);
                return group != null && group.getContentItems().size() > 0L;
            }
        });
        this.m_checkboxGroup = new CheckboxGroup(ASSOCIATED_ITEMS){

            public boolean isVisible(PageState state) {
                ContentGroupContainer item = (ContentGroupContainer)ContentGroupPropertyForm.this.getItemSelectionModel().getSelectedObject(state);
                ContentGroup group = ContentGroupPropertyForm.this.getCurrentGroup(item, ContentGroupPropertyForm.this.m_attributeName);
                return group != null && group.getContentItems().size() > 0L;
            }
        };
        this.add((Component)this.m_checkboxGroup);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.content_group_new_item")));
        try {
            this.add((Component)new ItemSearchWidget(RELATED_ITEM, this.getSearchContentType()));
        }
        catch (DataObjectNotFoundException de) {
            throw new UncheckedWrapperException((Throwable)de);
        }
    }

    @Override
    public void init(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"here in init");
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ContentGroupContainer item = (ContentGroupContainer)this.getItemSelectionModel().getSelectedObject(state);
        ContentGroup group = this.getCurrentGroup(item, this.m_attributeName);
        if (group != null) {
            data.put((Object)"name", (Object)group.getName());
        }
        if (group != null) {
            ItemCollection collection = group.getContentItems();
            ArrayList<String> selected = new ArrayList<String>();
            while (collection.next()) {
                s_log.debug((Object)("NAME = " + collection.getContentItem().getName()));
                s_log.debug((Object)("ID = " + collection.getID()));
                this.m_checkboxGroup.addOption(new Option(collection.getID().toString(), collection.getContentItem().getName()), state);
                selected.add(collection.getID().toString());
            }
            data.put((Object)ASSOCIATED_ITEMS, (Object)selected.toArray());
        }
    }

    @Override
    public void process(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"here in process");
        ContentGroupContainer item = (ContentGroupContainer)this.getItemSelectionModel().getSelectedObject(e.getPageState());
        FormData data = e.getFormData();
        if (item != null && !this.getSaveCancelSection().getCancelButton().isSelected(e.getPageState())) {
            ContentGroup group = this.getCurrentGroup(item, this.m_attributeName);
            if (group == null) {
                group = new ContentGroup();
                group.setMaster((ContentItem)((Object)item));
                this.setContentGroup(item, group, this.m_attributeName);
            }
            group.setName((String)data.get((Object)"name"));
            group.save();
            ItemCollection collection = group.getContentItems();
            ArrayList<String> ids = new ArrayList<String>();
            HashMap<String, ContentItem> itemMap = new HashMap<String, ContentItem>();
            while (collection.next()) {
                String id = collection.getID().toString();
                itemMap.put(id, collection.getContentItem());
                ids.add(id);
                s_log.debug((Object)("XXXX adding " + id));
                s_log.debug((Object)("XXXX isDeleted? " + collection.getContentItem().isDeleted()));
            }
            String[] values = (String[])this.m_checkboxGroup.getValue(e.getPageState());
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    ids.remove(values[i]);
                    s_log.debug((Object)("marking " + values[i] + " for keeping"));
                }
            }
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                s_log.debug((Object)"Removing item");
                group.removeContentItem((ContentItem)itemMap.get((String)iterator.next()));
            }
            ContentItem newItem = (ContentItem)data.get((Object)RELATED_ITEM);
            if (newItem != null) {
                group.addContentItem(newItem);
            }
            group.save();
            ((ContentItem)((Object)item)).save();
        }
    }

    private ContentGroup getCurrentGroup(ContentGroupContainer item, String attributeName) {
        return item.getContentGroup(attributeName);
    }

    private void setContentGroup(ContentGroupContainer item, ContentGroup group, String attributeName) {
        item.setContentGroup(attributeName, group);
    }

    protected String getSearchContentType() {
        return null;
    }
}

