/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.ui.GenericAddressPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class GenericAddressPropertiesStep
extends SimpleEditStep {
    public static final String EDIT_SHEET_NAME = "edit";

    public GenericAddressPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        this.createEditSheet(itemModel);
        this.setDisplayComponent(GenericAddressPropertiesStep.getAddressPropertySheet(itemModel));
    }

    protected void createEditSheet(ItemSelectionModel itemModel) {
        GenericAddressPropertyForm editSheet = new GenericAddressPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, "Edit", new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
    }

    public static Component getAddressPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add((String)GlobalizationUtil.globalize("cms.contenttypes.ui.name").localize(), "name");
        sheet.add((String)GlobalizationUtil.globalize("cms.contenttypes.ui.title").localize(), "title");
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.address").localize(), "address");
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.postal_code").localize(), "postalCode");
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.city").localize(), "city");
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.state").localize(), "state");
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.iso_country_code").localize(), "isoCountryCode", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                GenericAddress address = (GenericAddress)item;
                if (address != null && address.getIsoCountryCode() != null) {
                    return GenericAddress.getCountryNameFromIsoCode(address.getIsoCountryCode());
                }
                return (String)GlobalizationUtil.globalize("cms.ui.unknown").localize();
            }
        });
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add((String)GlobalizationUtil.globalize("cms.ui.authoring.page_launch_date").localize(), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return (String)GlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        return sheet;
    }
}

