/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.ui.GenericAddressPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenericAddressPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(GenericAddressPropertyForm.class);
    private GenericAddressPropertiesStep m_step;
    public static final String ADDRESS = "address";
    public static final String POSTAL_CODE = "postalCode";
    public static final String CITY = "city";
    public static final String STATE = "state";
    public static final String ISO_COUNTRY_CODE = "isoCountryCode";
    public static final String ID = "Address_edit";

    public GenericAddressPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericAddressPropertyForm(ItemSelectionModel itemModel, GenericAddressPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    @Override
    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.address").localize()));
        StringParameter addressParam = new StringParameter(ADDRESS);
        addressParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        addressParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextArea address = new TextArea((ParameterModel)addressParam);
        address.setRows(5);
        address.setCols(30);
        this.add((Component)address);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.postal_code").localize()));
        StringParameter postalCodeParam = new StringParameter(POSTAL_CODE);
        TextField postalCode = new TextField((ParameterModel)postalCodeParam);
        this.add((Component)postalCode);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.city").localize()));
        StringParameter cityParam = new StringParameter(CITY);
        TextField city = new TextField((ParameterModel)cityParam);
        this.add((Component)city);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.state").localize()));
        StringParameter stateParam = new StringParameter(STATE);
        TextField state = new TextField((ParameterModel)stateParam);
        this.add((Component)state);
        if (!GenericAddress.getConfig().getHideCountryCodeSelection()) {
            this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.iso_country_code").localize()));
            StringParameter countryParam = new StringParameter(ISO_COUNTRY_CODE);
            countryParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 2));
            SingleSelect country = new SingleSelect((ParameterModel)countryParam);
            country.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
            for (Map.Entry elem : GenericAddress.getSortedListOfCountries(null).entrySet()) {
                country.addOption(new Option(((String)elem.getValue()).toString(), ((String)elem.getKey()).toString()));
            }
            country.addValidationListener(new ParameterListener(){

                public void validate(ParameterEvent e) throws FormProcessException {
                    ParameterData data = e.getParameterData();
                    String isoCode = (String)data.getValue();
                    s_log.debug((Object)("ISO code is : " + isoCode));
                    if (isoCode == null || isoCode.length() == 0) {
                        data.addError((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.error_iso_country").localize());
                    }
                }
            });
            this.add((Component)country);
        }
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        GenericAddress address = (GenericAddress)super.initBasicWidgets(fse);
        data.put((Object)ADDRESS, (Object)address.getAddress());
        data.put((Object)POSTAL_CODE, (Object)address.getPostalCode());
        data.put((Object)CITY, (Object)address.getCity());
        data.put((Object)STATE, (Object)address.getState());
        if (!GenericAddress.getConfig().getHideCountryCodeSelection()) {
            data.put((Object)ISO_COUNTRY_CODE, (Object)address.getIsoCountryCode());
        }
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        GenericAddress address = (GenericAddress)super.processBasicWidgets(fse);
        if (address != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            address.setAddress((String)data.get((Object)ADDRESS));
            address.setPostalCode((String)data.get((Object)POSTAL_CODE));
            address.setCity((String)data.get((Object)CITY));
            address.setState((String)data.get((Object)STATE));
            address.setIsoCountryCode((String)data.get((Object)ISO_COUNTRY_CODE));
            address.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

