/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.ui.GenericContactAttachAddressPropertyForm;
import com.arsdigita.cms.contenttypes.ui.GenericContactDeleteAddressForm;
import com.arsdigita.cms.contenttypes.ui.GenericContactEditAddressPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

public class GenericContactAddressPropertiesStep
extends SimpleEditStep {
    public static final String ADD_ADDRESS_SHEET_NAME = "addAddress";
    public static final String EDIT_ADDRESS_SHEET_NAME = "editAddress";
    public static final String CHANGE_ADDRESS_SHEET_NAME = "changeAddress";
    public static final String DELETE_ADDRESS_SHEET_NAME = "deleteAddress";
    private ItemSelectionModel itemModel;

    public GenericContactAddressPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this(itemModel, parent, "");
    }

    public GenericContactAddressPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent, String prefix) {
        super(itemModel, parent, prefix);
        this.itemModel = itemModel;
        GenericContactAttachAddressPropertyForm attachAddressSheet = new GenericContactAttachAddressPropertyForm(itemModel, this);
        GenericContactAttachAddressPropertyForm reattachAddressSheet = new GenericContactAttachAddressPropertyForm(itemModel, this);
        GenericContactEditAddressPropertyForm editAddressSheet = new GenericContactEditAddressPropertyForm(itemModel, this);
        GenericContactDeleteAddressForm deleteAddressSheet = new GenericContactDeleteAddressForm(itemModel, this);
        this.add(ADD_ADDRESS_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.attach_address").localize(), new AttachAddressWorkflowLockedComponentAccess((Component)attachAddressSheet, itemModel), attachAddressSheet.getSaveCancelSection().getCancelButton());
        this.add(CHANGE_ADDRESS_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.reattach_address").localize(), new EditAddressWorkflowLockedComponentAccess((Component)reattachAddressSheet, itemModel), reattachAddressSheet.getSaveCancelSection().getCancelButton());
        this.add(DELETE_ADDRESS_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.delete_address").localize(), new EditAddressWorkflowLockedComponentAccess((Component)deleteAddressSheet, itemModel), deleteAddressSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(GenericContactAddressPropertiesStep.getAddressPropertySheet(itemModel));
    }

    public static Component getAddressPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.address").localize(), "address.address");
        if (!GenericContact.getConfig().getHideAddressPostalCode()) {
            sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.postal_code").localize(), "address.postalCode");
        }
        sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.city").localize(), "address.city");
        if (!GenericContact.getConfig().getHideAddressState()) {
            sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.state").localize(), "address.state");
        }
        if (!GenericContact.getConfig().getHideAddressCountry()) {
            sheet.add((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.iso_country_code").localize(), "address.isoCountryCode", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    GenericAddress Address = ((GenericContact)item).getAddress();
                    if (Address != null && Address.getIsoCountryCode() != null) {
                        return GenericAddress.getCountryNameFromIsoCode(Address.getIsoCountryCode());
                    }
                    return (String)ContenttypesGlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        return sheet;
    }

    public static Component getEmptyBaseAddressPropertySheet(ItemSelectionModel itemModel) {
        return new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.emptyAddress").localize());
    }

    private class AttachAddressWorkflowLockedComponentAccess
    extends WorkflowLockedComponentAccess {
        public AttachAddressWorkflowLockedComponentAccess(Component c, ItemSelectionModel i) {
            super(c, i);
        }

        @Override
        public boolean isVisible(PageState state) {
            GenericContact contact = (GenericContact)GenericContactAddressPropertiesStep.this.itemModel.getSelectedObject(state);
            return !contact.hasAddress();
        }
    }

    private class EditAddressWorkflowLockedComponentAccess
    extends WorkflowLockedComponentAccess {
        public EditAddressWorkflowLockedComponentAccess(Component c, ItemSelectionModel i) {
            super(c, i);
        }

        @Override
        public boolean isVisible(PageState state) {
            GenericContact contact = (GenericContact)GenericContactAddressPropertiesStep.this.itemModel.getSelectedObject(state);
            return contact.hasAddress();
        }
    }
}

