/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.ui.GenericContactAddressPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;

public class GenericContactAttachAddressPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger logger = Logger.getLogger(GenericContactPropertyForm.class);
    private GenericContactAddressPropertiesStep m_step;
    private ItemSearchWidget m_itemSearch;
    private SaveCancelSection m_saveCancelSection;
    private final String ITEM_SEARCH = "contactAddress";
    public static final String ID = "ContactAttachAddress";

    public GenericContactAttachAddressPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericContactAttachAddressPropertyForm(ItemSelectionModel itemModel, GenericContactAddressPropertiesStep step) {
        super(ID, itemModel);
        this.addSubmissionListener(this);
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
    }

    @Override
    public void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_address").localize()));
        this.m_itemSearch = new ItemSearchWidget("contactAddress", ContentType.findByAssociatedObjectType("com.arsdigita.cms.contenttypes.GenericAddress"));
        this.m_itemSearch.setDisableCreatePane(true);
        this.add((Component)this.m_itemSearch);
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        this.setVisible(state, true);
        if (contact != null) {
            data.put((Object)"contactAddress", (Object)contact.getAddress());
        }
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        if (!this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            GenericAddress address = (GenericAddress)data.get((Object)"contactAddress");
            address = (GenericAddress)address.getContentBundle().getInstance(contact.getLanguage());
            contact.setAddress(address);
        }
        this.init(fse);
    }

    @Override
    public void addSaveCancelSection() {
        try {
            this.getSaveCancelSection().getSaveButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    GenericContact contact = (GenericContact)GenericContactAttachAddressPropertyForm.this.getItemSelectionModel().getSelectedObject(e.getPageState());
                    Submit target = (Submit)e.getTarget();
                    if (contact.getAddress() != null) {
                        target.setButtonLabel((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_address.change").localize());
                    } else {
                        target.setButtonLabel((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_address.add").localize());
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new UncheckedWrapperException("this cannot happen", (Throwable)ex);
        }
    }

    @Override
    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        if (data.get((Object)"contactAddress") == null) {
            throw new FormProcessException((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_address.wrong_type").localize());
        }
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        GenericAddress address = (GenericAddress)data.get((Object)"contactAddress");
        if (!address.getContentBundle().hasInstance(contact.getLanguage(), Kernel.getConfig().languageIndependentItems())) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_address.no_suitable_language_variant"));
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.getSaveCancelSection().getCancelButton().isSelected(e.getPageState())) {
            this.init(e);
            throw new FormProcessException((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_address.cancelled").localize());
        }
    }
}

