/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericContactPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;

public class GenericContactAttachPersonPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger logger = Logger.getLogger(GenericContactPropertyForm.class);
    private GenericContactPersonPropertiesStep m_step;
    private ItemSearchWidget m_itemSearch;
    private SaveCancelSection m_saveCancelSection;
    private final String ITEM_SEARCH = "contactPerson";
    private final String CONTACTS_KEY = "link.linkKey";
    public static final String ID = "ContactAttachPerson";

    public GenericContactAttachPersonPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericContactAttachPersonPropertyForm(ItemSelectionModel itemModel, GenericContactPersonPropertiesStep step) {
        super(ID, itemModel);
        this.addSubmissionListener(this);
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
    }

    @Override
    public void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_person").localize()));
        this.m_itemSearch = new ItemSearchWidget("contactPerson", ContentType.findByAssociatedObjectType("com.arsdigita.cms.contenttypes.GenericPerson"));
        this.m_itemSearch.setDisableCreatePane(true);
        this.add((Component)this.m_itemSearch);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contact.type")));
        StringParameter contactTypeParam = new StringParameter("link.linkKey");
        SingleSelect contactType = new SingleSelect((ParameterModel)contactTypeParam);
        contactType.addValidationListener((ParameterListener)new NotNullValidationListener());
        contactType.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        GenericContactTypeCollection contacttypes = new GenericContactTypeCollection();
        contacttypes.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (contacttypes.next()) {
            RelationAttribute ct = contacttypes.getRelationAttribute();
            contactType.addOption(new Option(ct.getKey(), ct.getName()));
        }
        this.add((Component)contactType);
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        this.setVisible(state, true);
        if (contact != null) {
            data.put((Object)"contactPerson", (Object)contact.getPerson());
            data.put((Object)"link.linkKey", (Object)contact.getContactType());
        }
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        if (!this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            GenericPerson person = (GenericPerson)data.get((Object)"contactPerson");
            person = (GenericPerson)person.getContentBundle().getInstance(contact.getLanguage());
            contact.setPerson(person, (String)data.get((Object)"link.linkKey"));
        }
        this.init(fse);
    }

    @Override
    public void addSaveCancelSection() {
        try {
            this.getSaveCancelSection().getSaveButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    GenericContact contact = (GenericContact)GenericContactAttachPersonPropertyForm.this.getItemSelectionModel().getSelectedObject(e.getPageState());
                    Submit target = (Submit)e.getTarget();
                    if (contact.getPerson() != null) {
                        target.setButtonLabel((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_person.change").localize());
                    } else {
                        target.setButtonLabel((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_person.add").localize());
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new UncheckedWrapperException("this cannot happen", (Throwable)ex);
        }
    }

    @Override
    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        if (data.get((Object)"contactPerson") == null) {
            throw new FormProcessException((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_person.wrong_type").localize());
        }
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        GenericPerson person = (GenericPerson)data.get((Object)"contactPerson");
        if (!person.getContentBundle().hasInstance(contact.getLanguage(), Kernel.getConfig().languageIndependentItems())) {
            data.addError("cms.contenttypes.ui.contact.select_person.no_suitable_language_variant");
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.getSaveCancelSection().getCancelButton().isSelected(e.getPageState())) {
            this.init(e);
            throw new FormProcessException((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.select_person.cancelled").localize());
        }
    }
}

