/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.ui.GenericContactAddressPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenericContactEditAddressPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger logger = Logger.getLogger(GenericContactPropertyForm.class);
    private GenericContactAddressPropertiesStep m_step;
    public static final String ADDRESS = "address";
    public static final String POSTAL_CODE = "postalCode";
    public static final String CITY = "city";
    public static final String STATE = "state";
    public static final String ISO_COUNTRY_CODE = "isoCountryCode";
    public static final String ID = "ContactEditAddress";

    public GenericContactEditAddressPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericContactEditAddressPropertyForm(ItemSelectionModel itemModel, GenericContactAddressPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    @Override
    public void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.address").localize()));
        StringParameter addressParam = new StringParameter(ADDRESS);
        addressParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        addressParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextArea address = new TextArea((ParameterModel)addressParam);
        address.setRows(5);
        address.setCols(30);
        this.add((Component)address);
        if (!GenericContact.getConfig().getHideAddressPostalCode()) {
            this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.postal_code").localize()));
            StringParameter postalCodeParam = new StringParameter(POSTAL_CODE);
            TextField postalCode = new TextField((ParameterModel)postalCodeParam);
            this.add((Component)postalCode);
        }
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.city").localize()));
        StringParameter cityParam = new StringParameter(CITY);
        TextField city = new TextField((ParameterModel)cityParam);
        this.add((Component)city);
        if (!GenericContact.getConfig().getHideAddressState()) {
            this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.state").localize()));
            StringParameter stateParam = new StringParameter(STATE);
            TextField state = new TextField((ParameterModel)stateParam);
            this.add((Component)state);
        }
        if (!GenericContact.getConfig().getHideAddressCountry()) {
            this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.iso_country_code").localize()));
            StringParameter countryParam = new StringParameter(ISO_COUNTRY_CODE);
            countryParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 2));
            SingleSelect country = new SingleSelect((ParameterModel)countryParam);
            country.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
            for (Map.Entry elem : GenericAddress.getSortedListOfCountries(null).entrySet()) {
                country.addOption(new Option(((String)elem.getValue()).toString(), ((String)elem.getKey()).toString()));
            }
            country.addValidationListener(new ParameterListener(){

                public void validate(ParameterEvent e) throws FormProcessException {
                    ParameterData data = e.getParameterData();
                    String isoCode = (String)data.getValue();
                    if (isoCode == null || isoCode.length() == 0) {
                        data.addError((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.address.error_iso_country").localize());
                    }
                }
            });
            this.add((Component)country);
        }
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        if (contact.getAddress() != null) {
            data.put((Object)ADDRESS, (Object)contact.getAddress().getAddress());
            data.put((Object)POSTAL_CODE, (Object)contact.getAddress().getPostalCode());
            data.put((Object)CITY, (Object)contact.getAddress().getCity());
            data.put((Object)STATE, (Object)contact.getAddress().getState());
            if (!GenericAddress.getConfig().getHideCountryCodeSelection()) {
                data.put((Object)ISO_COUNTRY_CODE, (Object)contact.getAddress().getIsoCountryCode());
            }
        }
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        if (this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            contact.getAddress().setAddress((String)data.get((Object)ADDRESS));
            contact.getAddress().setPostalCode((String)data.get((Object)POSTAL_CODE));
            contact.getAddress().setCity((String)data.get((Object)CITY));
            contact.getAddress().setState((String)data.get((Object)STATE));
            contact.getAddress().setIsoCountryCode((String)data.get((Object)ISO_COUNTRY_CODE));
            contact.getAddress().save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

