/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.ui.GenericContactPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.globalization.GlobalizationHelper;
import org.apache.log4j.Logger;

public class GenericContactEditPersonPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger logger = Logger.getLogger(GenericContactPropertyForm.class);
    private GenericContactPersonPropertiesStep m_step;
    public static final String SURNAME = "surname";
    public static final String GIVENNAME = "givenname";
    public static final String TITLEPRE = "titlepre";
    public static final String TITLEPOST = "titlepost";
    public static final String CONTACTS_KEY = "link.linkKey";
    public static final String ID = "ContactEditPerson";

    public GenericContactEditPersonPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericContactEditPersonPropertyForm(ItemSelectionModel itemModel, GenericContactPersonPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    @Override
    public void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.surname").localize()));
        StringParameter surnameParam = new StringParameter(SURNAME);
        surnameParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        surnameParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextField surname = new TextField((ParameterModel)surnameParam);
        this.add((Component)surname);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.givenname").localize()));
        StringParameter givennameParam = new StringParameter(GIVENNAME);
        givennameParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        givennameParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextField givenname = new TextField((ParameterModel)givennameParam);
        this.add((Component)givenname);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.titlepre").localize()));
        StringParameter titlepreParam = new StringParameter(TITLEPRE);
        titlepreParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextField titlepre = new TextField((ParameterModel)titlepreParam);
        this.add((Component)titlepre);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.titlepost").localize()));
        StringParameter titlepostParam = new StringParameter(TITLEPOST);
        titlepostParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextField titlepost = new TextField((ParameterModel)titlepostParam);
        this.add((Component)titlepost);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contact.type")));
        StringParameter contactTypeParam = new StringParameter(CONTACTS_KEY);
        SingleSelect contactType = new SingleSelect((ParameterModel)contactTypeParam);
        contactType.addValidationListener((ParameterListener)new NotNullValidationListener());
        contactType.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        GenericContactTypeCollection contacttypes = new GenericContactTypeCollection();
        contacttypes.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (contacttypes.next()) {
            RelationAttribute ct = contacttypes.getRelationAttribute();
            contactType.addOption(new Option(ct.getKey(), ct.getName()));
        }
        this.add((Component)contactType);
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        if (contact.getPerson() != null) {
            data.put((Object)SURNAME, (Object)contact.getPerson().getSurname());
            data.put((Object)GIVENNAME, (Object)contact.getPerson().getGivenName());
            data.put((Object)TITLEPRE, (Object)contact.getPerson().getTitlePre());
            data.put((Object)TITLEPOST, (Object)contact.getPerson().getTitlePost());
        }
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact contact = (GenericContact)this.getItemSelectionModel().getSelectedObject(state);
        if (this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            contact.getPerson().setSurname((String)data.get((Object)SURNAME));
            contact.getPerson().setGivenName((String)data.get((Object)GIVENNAME));
            contact.getPerson().setTitlePre((String)data.get((Object)TITLEPRE));
            contact.getPerson().setTitlePost((String)data.get((Object)TITLEPOST));
            contact.getPerson().save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

