/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactEntry;
import com.arsdigita.cms.contenttypes.GenericContactEntryCollection;
import com.arsdigita.cms.contenttypes.GenericContactEntryKeys;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class GenericContactEntriesTable
extends Table
implements TableActionListener {
    private final String TABLE_COL_EDIT = "table_col_edit";
    private final String TABLE_COL_DEL = "table_col_del";
    private ItemSelectionModel m_itemModel;

    public GenericContactEntriesTable(ItemSelectionModel itemModel) {
        this.m_itemModel = itemModel;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.none")));
        TableColumnModel tab_model = this.getColumnModel();
        tab_model.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.key").localize(), (Object)"table_col_edit"));
        tab_model.add(new TableColumn(1, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.value").localize()));
        tab_model.add(new TableColumn(2, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.description").localize()));
        tab_model.add(new TableColumn(3, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.action").localize(), (Object)"table_col_del"));
        this.setModelBuilder(new ContactTableModelBuilder(itemModel));
        tab_model.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        tab_model.get(3).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent evt) {
        PageState state = evt.getPageState();
        GenericContactEntry contactEntry = new GenericContactEntry(new BigDecimal(evt.getRowKey().toString()));
        GenericContact contact = (GenericContact)this.m_itemModel.getSelectedObject(state);
        TableColumn col = this.getColumnModel().get(evt.getColumn().intValue());
        if (col.getHeaderKey().toString().equals("table_col_edit")) {
            // empty if block
        }
        if (col.getHeaderKey().toString().equals("table_col_del")) {
            contact.removeContactEntry(contactEntry);
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager sm = Utilities.getSecurityManager(state);
            GenericContact contact = (GenericContact)GenericContactEntriesTable.this.m_itemModel.getSelectedObject(state);
            boolean canDelete = sm.canAccess(state.getRequest(), "delete_item", (ContentItem)contact);
            if (canDelete) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.confirm_delete").localize());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager sm = Utilities.getSecurityManager(state);
            GenericContact contact = (GenericContact)GenericContactEntriesTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = sm.canAccess(state.getRequest(), "edit_item", (ContentItem)contact);
            if (canEdit) {
                ControlLink link = new ControlLink(value.toString());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class ContactTableModel
    implements TableModel {
        private final int MAX_DESC_LENGTH = 25;
        private Table m_table;
        private GenericContactEntryCollection m_contactEntryCollection;
        private GenericContactEntry m_contactEntry;

        private ContactTableModel(Table t, PageState ps, GenericContact contact) {
            this.m_table = t;
            this.m_contactEntryCollection = contact.getContactEntries();
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            if (this.m_contactEntryCollection != null && this.m_contactEntryCollection.next()) {
                this.m_contactEntry = this.m_contactEntryCollection.getContactEntry();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    GenericContactEntryKeys keys = new GenericContactEntryKeys(this.m_contactEntry.getKey());
                    keys.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
                    if (keys.next()) {
                        String key = keys.getName();
                        keys.close();
                        return key;
                    }
                    return this.m_contactEntry.getKey();
                }
                case 1: {
                    return this.m_contactEntry.getValue();
                }
                case 2: {
                    return this.m_contactEntry.getDescription() != null && this.m_contactEntry.getDescription().length() > 25 ? this.m_contactEntry.getDescription().substring(0, 25) : this.m_contactEntry.getDescription();
                }
                case 3: {
                    return GlobalizationUtil.globalize("cms.ui.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_contactEntry.getID();
        }
    }

    private class ContactTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_itemModel;

        public ContactTableModelBuilder(ItemSelectionModel itemModel) {
            this.m_itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            GenericContact contact = (GenericContact)this.m_itemModel.getSelectedObject(state);
            return new ContactTableModel(table, state, contact);
        }
    }
}

