/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactEntry;
import com.arsdigita.cms.contenttypes.GenericContactEntryKeys;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.globalization.GlobalizationHelper;
import org.apache.log4j.Logger;

public class GenericContactEntryAddForm
extends BasicItemForm {
    private static final Logger s_log = Logger.getLogger(GenericContactEntryAddForm.class);
    private ItemSelectionModel m_itemModel;

    public GenericContactEntryAddForm(ItemSelectionModel itemModel) {
        super("ContactEntryAddForm", itemModel);
        this.m_itemModel = itemModel;
    }

    @Override
    protected void addWidgets() {
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.key")));
        StringParameter contactEntryKeyParam = new StringParameter("key");
        SingleSelect contactEntryKey = new SingleSelect((ParameterModel)contactEntryKeyParam);
        contactEntryKey.addValidationListener((ParameterListener)new NotNullValidationListener());
        contactEntryKey.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        GenericContactEntryKeys keyList = new GenericContactEntryKeys();
        keyList.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (keyList.next()) {
            String currentKey = keyList.getKey();
            contactEntryKey.addOption(new Option(currentKey, keyList.getName()));
        }
        this.add((Component)contactEntryKey);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.value")));
        StringParameter contactEntryValueParam = new StringParameter("value");
        TextField contactEntryValue = new TextField((ParameterModel)contactEntryValueParam);
        contactEntryValue.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)contactEntryValue);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry.description")));
        StringParameter contactEntryDescriptionParam = new StringParameter("description");
        TextField contactEntryDescription = new TextField((ParameterModel)contactEntryDescriptionParam);
        this.add((Component)contactEntryDescription);
    }

    @Override
    public void init(FormSectionEvent fse) {
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        GenericContact contact = (GenericContact)this.m_itemModel.getSelectedObject(fse.getPageState());
        if (contact != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            GenericContactEntry contactEntry = new GenericContactEntry(contact, (String)data.get((Object)"key"), (String)data.get((Object)"value"), (String)data.get((Object)"description"));
            contact.addContactEntry(contactEntry);
        }
    }
}

