/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class GenericContactPersonSheet
extends Table
implements TableActionListener {
    private final String TABLE_COL_EDIT = "table_col_edit";
    private final String TABLE_COL_DEL = "table_col_del";
    private ItemSelectionModel m_itemModel;

    public GenericContactPersonSheet(ItemSelectionModel itemModel) {
        this.m_itemModel = itemModel;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.emptyPerson")));
        TableColumnModel colModel = this.getColumnModel();
        colModel.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.person").localize(), (Object)"table_col_edit"));
        colModel.add(new TableColumn(1, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.delete_person").localize(), (Object)"table_col_del"));
        this.setModelBuilder(new GenericContactPersonSheetModelBuilder(itemModel));
        colModel.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        colModel.get(1).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent event) {
        PageState state = event.getPageState();
        GenericContact contact = (GenericContact)this.m_itemModel.getSelectedObject(state);
        TableColumn column = this.getColumnModel().get(event.getColumn().intValue());
        if (!column.getHeaderKey().toString().equals("table_col_edit") && column.getHeaderKey().toString().equals("table_col_del")) {
            contact.unsetPerson();
        }
    }

    public void headSelected(TableActionEvent event) {
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericContact contact = (GenericContact)GenericContactPersonSheet.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "delete_item", (ContentItem)contact);
            if (canEdit) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.person.confirm_remove").localize());
                return link;
            }
            Label label = new Label(value.toString());
            return label;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericContact contact = (GenericContact)GenericContactPersonSheet.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)contact);
            if (canEdit) {
                GenericPerson person;
                try {
                    person = new GenericPerson((BigDecimal)key);
                }
                catch (DataObjectNotFoundException ex) {
                    return new Label(value.toString());
                }
                ContentSection section = CMS.getContext().getContentSection();
                ItemResolver resolver = section.getItemResolver();
                return new Link(value.toString(), resolver.generateItemURL(state, person, section, person.getVersion()));
            }
            return new Label(value.toString());
        }
    }

    private class GenericContactPersonSheetModel
    implements TableModel {
        private Table m_table;
        private GenericPerson m_person;
        private boolean m_done;

        public GenericContactPersonSheetModel(Table table, PageState state, GenericContact contact) {
            this.m_table = table;
            this.m_person = contact.getPerson();
            this.m_done = this.m_person != null;
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            boolean ret;
            if (this.m_done) {
                ret = true;
                this.m_done = false;
            } else {
                ret = false;
            }
            return ret;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_person.getFullName();
                }
                case 1: {
                    return ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.delete_person").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_person.getID();
        }
    }

    private class GenericContactPersonSheetModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_itemModel;

        public GenericContactPersonSheetModelBuilder(ItemSelectionModel itemModel) {
            this.m_itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            GenericContact contact = (GenericContact)this.m_itemModel.getSelectedObject(state);
            return new GenericContactPersonSheetModel(table, state, contact);
        }
    }
}

