/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.ui.GenericContactAddressPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactEntriesPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericContactPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;
import org.apache.log4j.Logger;

public class GenericContactPropertiesStep
extends SimpleEditStep {
    private static final Logger logger = Logger.getLogger(GenericContactPropertiesStep.class);
    public static final String EDIT_BASIC_SHEET_NAME = "editBasic";

    public GenericContactPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_BASIC_SHEET_NAME);
        SegmentedPanel segmentedPanel = this.createEditSheet(itemModel, parent);
        this.setDisplayComponent((Component)segmentedPanel);
    }

    protected SegmentedPanel createEditSheet(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        SegmentedPanel segmentedPanel = new SegmentedPanel();
        SimpleEditStep basicProperties = new SimpleEditStep(itemModel, parent, EDIT_BASIC_SHEET_NAME);
        GenericContactPropertyForm editBasicSheet = new GenericContactPropertyForm(itemModel, this);
        basicProperties.add(EDIT_BASIC_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.edit_basic_properties").localize(), new WorkflowLockedComponentAccess((Component)editBasicSheet, itemModel), editBasicSheet.getSaveCancelSection().getCancelButton());
        basicProperties.setDisplayComponent(GenericContactPropertiesStep.getContactPropertySheet(itemModel));
        segmentedPanel.addSegment((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.basic_properties").localize()), (Component)basicProperties);
        if (!GenericContact.getConfig().getHidePerson()) {
            GenericContactPersonPropertiesStep personProperties = new GenericContactPersonPropertiesStep(itemModel, parent);
            segmentedPanel.addSegment((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.person").localize()), (Component)personProperties);
        }
        if (!GenericContact.getConfig().getHideAddress()) {
            GenericContactAddressPropertiesStep addressProperties = new GenericContactAddressPropertiesStep(itemModel, parent);
            segmentedPanel.addSegment((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.address").localize()), (Component)addressProperties);
        }
        GenericContactEntriesPropertiesStep contactEntries = new GenericContactEntriesPropertiesStep(itemModel, parent);
        segmentedPanel.addSegment((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.contactEntry").localize()), (Component)contactEntries);
        return segmentedPanel;
    }

    public static Component getContactPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize("cms.contenttypes.ui.name"), "name");
        sheet.add(GlobalizationUtil.globalize("cms.contenttypes.ui.title"), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(GlobalizationUtil.globalize("cms.ui.authoring.page_launch_date"), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject obj, String attribute, PageState state) {
                    ContentPage page = (ContentPage)obj;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return (String)GlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        return sheet;
    }
}

