/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.ui.GenericPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelConfig;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class GenericContactTypeAddForm
extends BasicItemForm {
    public static final String KEY = "attr_key";
    public static final String LANGUAGE = "lang";
    public static final String NAME = "name";
    private static final Logger s_log = Logger.getLogger(GenericContactTypeAddForm.class);
    private GenericPersonPropertiesStep m_step;
    private SaveCancelSection m_saveCancelSection;
    private ItemSelectionModel m_itemModel;
    private SingleSelect language;

    public GenericContactTypeAddForm(ItemSelectionModel itemModel) {
        super("ContactEntryAddForm", itemModel);
        this.m_itemModel = itemModel;
    }

    @Override
    protected void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.key").localize()));
        StringParameter keyParam = new StringParameter(KEY);
        keyParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        keyParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextField key = new TextField((ParameterModel)keyParam);
        this.add((Component)key);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.language").localize()));
        StringParameter languageParam = new StringParameter(LANGUAGE);
        this.language = new SingleSelect((ParameterModel)languageParam);
        this.language.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.language.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.name").localize()));
        StringParameter nameParam = new StringParameter(NAME);
        nameParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        nameParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextField name = new TextField((ParameterModel)nameParam);
        this.add((Component)name);
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        RelationAttribute contacttype = (RelationAttribute)this.getItemSelectionModel().getSelectedObject(state);
        GenericContactTypeCollection contacttypeCollection = new GenericContactTypeCollection(contacttype.getKey());
        KernelConfig kernelConfig = Kernel.getConfig();
        StringTokenizer strTok = kernelConfig.getSupportedLanguagesTokenizer();
        while (strTok.hasMoreTokens()) {
            String code = strTok.nextToken();
            if (contacttypeCollection.hasLanguage(code)) continue;
            this.language.addOption(new Option(code, new Locale(code).getDisplayLanguage()), state);
        }
        data.put((Object)KEY, (Object)contacttype.getKey());
        data.put((Object)LANGUAGE, (Object)contacttype.getLanguage());
        data.put((Object)NAME, (Object)contacttype.getName());
        this.setVisible(state, true);
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        RelationAttribute contacttype = (RelationAttribute)this.getItemSelectionModel().getSelectedObject(state);
        if (!this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            contacttype.setKey((String)data.get((Object)KEY));
            contacttype.setLanguage((String)data.get((Object)LANGUAGE));
            contacttype.setName((String)data.get((Object)NAME));
        }
        this.init(fse);
    }
}

