/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class GenericContactTypeTable
extends Table
implements TableActionListener {
    private final String TABLE_COL_EDIT = "table_col_edit";
    private final String TABLE_COL_DEL = "table_col_del";
    private ItemSelectionModel m_itemModel;

    public GenericContactTypeTable(ItemSelectionModel itemModel) {
        this.m_itemModel = itemModel;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.none")));
        TableColumnModel tab_model = this.getColumnModel();
        tab_model.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.key").localize(), (Object)"table_col_edit"));
        tab_model.add(new TableColumn(1, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.title").localize()));
        tab_model.add(new TableColumn(2, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttypes.action").localize(), (Object)"table_col_del"));
        this.setModelBuilder(new GenericContactTypeTableModelBuilder(itemModel));
        tab_model.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        tab_model.get(2).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent evt) {
        PageState state = evt.getPageState();
        RelationAttribute contacttype = new RelationAttribute(new BigDecimal(evt.getRowKey().toString()));
        TableColumn col = this.getColumnModel().get(evt.getColumn().intValue());
        if (col.getHeaderKey().toString().equals("table_col_edit")) {
            // empty if block
        }
        if (col.getHeaderKey().toString().equals("table_col_del")) {
            contacttype.delete();
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager sm = Utilities.getSecurityManager(state);
            RelationAttribute contacttype = (RelationAttribute)GenericContactTypeTable.this.m_itemModel.getSelectedObject(state);
            ControlLink link = new ControlLink(value.toString());
            link.setConfirmation((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contacttype.confirm_delete").localize());
            return link;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager sm = Utilities.getSecurityManager(state);
            RelationAttribute contacttype = (RelationAttribute)GenericContactTypeTable.this.m_itemModel.getSelectedObject(state);
            ControlLink link = new ControlLink(value.toString());
            return link;
        }
    }

    private class GenericContactTypeTableModel
    implements TableModel {
        private final int MAX_DESC_LENGTH = 25;
        private Table m_table;
        private RelationAttribute m_contacttype;
        private GenericContactTypeCollection m_contacttypeCollection = new GenericContactTypeCollection();

        private GenericContactTypeTableModel(Table t, PageState ps, RelationAttribute contacttype) {
            this.m_table = t;
            this.m_contacttype = contacttype;
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            if (this.m_contacttypeCollection != null && this.m_contacttypeCollection.next()) {
                this.m_contacttype = this.m_contacttypeCollection.getRelationAttribute();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_contacttypeCollection.getKey();
                }
                case 1: {
                    return this.m_contacttypeCollection.getName();
                }
                case 2: {
                    return GlobalizationUtil.globalize("cms.ui.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_contacttype.getKey();
        }
    }

    private class GenericContactTypeTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_itemModel;

        public GenericContactTypeTableModelBuilder(ItemSelectionModel itemModel) {
            this.m_itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            RelationAttribute contacttype = (RelationAttribute)this.m_itemModel.getSelectedObject(state);
            return new GenericContactTypeTableModel(table, state, contacttype);
        }
    }
}

