/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.xml.Element;

public class GenericOrgaUnitContactsTab
implements GenericOrgaUnitTab {
    @Override
    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        return !this.getData(orgaunit).isEmpty();
    }

    @Override
    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        GenericOrganizationalUnitContactCollection contacts = this.getData(orgaunit, state);
        Element contactsElem = parent.newChildElement("contacts");
        while (contacts.next()) {
            GenericContact contact = contacts.getContact();
            this.generateGenericContactXML(contact, contactsElem, state, Integer.toString(contacts.getContactOrder()), true);
        }
    }

    protected void generateGenericContactXML(GenericContact contact, Element parent, PageState state, String order, boolean withPerson) {
        ContactXmlLGenerator generator = new ContactXmlLGenerator(contact);
        generator.generateXML(state, parent, order);
    }

    protected GenericOrganizationalUnitContactCollection getData(GenericOrganizationalUnit orgaunit, PageState state) {
        return this.getData(orgaunit);
    }

    protected GenericOrganizationalUnitContactCollection getData(GenericOrganizationalUnit orgaunit) {
        return orgaunit.getContacts();
    }

    private class ContactXmlLGenerator
    extends SimpleXMLGenerator {
        private GenericContact contact;

        public ContactXmlLGenerator(GenericContact contact) {
            this.contact = contact;
        }

        @Override
        protected ContentItem getContentItem(PageState state) {
            return this.contact;
        }
    }
}

