/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class GenericOrgaUnitExtraXmlGenerator
implements ExtraXMLGenerator {
    private static final Logger logger = Logger.getLogger(GenericOrgaUnitExtraXmlGenerator.class);
    private boolean listMode = false;
    private static final String SELECTED_TAB_PARAM = "selectedTab";
    private String showOnly;

    @Override
    public void generateXML(ContentItem item, Element element, PageState state) {
        long start = System.currentTimeMillis();
        if (!(item instanceof GenericOrganizationalUnit)) {
            throw new IllegalArgumentException("This ExtraXMLGenerator supports only instances of GenericOrganizationalUnit only.");
        }
        if (this.listMode) {
            return;
        }
        Element orgaUnitTabsElem = element.newChildElement("orgaUnitTabs");
        Element availableTabsElem = orgaUnitTabsElem.newChildElement("availableTabs");
        GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)item;
        Map<String, GenericOrgaUnitTab> tabs = this.processTabConfig(this.getTabConfig());
        String selected = state.getRequest().getParameter(SELECTED_TAB_PARAM);
        if (this.showOnly != null && !this.showOnly.isEmpty()) {
            selected = this.showOnly;
        }
        if (selected == null || selected.isEmpty()) {
            selected = new ArrayList<String>(tabs.keySet()).get(0);
        }
        long availableStart = System.currentTimeMillis();
        if (this.showOnly == null || this.showOnly.isEmpty()) {
            for (Map.Entry<String, GenericOrgaUnitTab> entry : tabs.entrySet()) {
                if (!entry.getValue().hasData(orgaunit, state)) continue;
                this.createAvailableTabElem(availableTabsElem, entry.getKey(), selected);
            }
        }
        logger.debug((Object)String.format("Created available tabs XML for GenericOrganizationalUnit '%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - availableStart));
        if (tabs.containsKey(selected) && tabs.get(selected).hasData(orgaunit, state)) {
            GenericOrgaUnitTab selectedTab = tabs.get(selected);
            Element selectedTabElem = orgaUnitTabsElem.newChildElement(SELECTED_TAB_PARAM);
            selectedTab.generateXml(orgaunit, selectedTabElem, state);
        } else {
            orgaUnitTabsElem.newChildElement("selectedTabNotAvailable");
        }
        logger.debug((Object)String.format("Generated XML for GenericOrganizationalUnit '%s' in %d ms", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    public void setShowOnly(String showOnly) {
        this.showOnly = showOnly;
    }

    private void createAvailableTabElem(Element parent, String key, String selected) {
        Element availableTabElem = parent.newChildElement("availableTab");
        availableTabElem.addAttribute("label", key);
        if (key.equals(selected)) {
            availableTabElem.addAttribute("selected", "true");
        } else {
            availableTabElem.addAttribute("selected", "false");
        }
    }

    public abstract String getTabConfig();

    private Map<String, GenericOrgaUnitTab> processTabConfig(String tabConfig) {
        long start = System.currentTimeMillis();
        String[] tokens = tabConfig.split(";");
        LinkedHashMap<String, GenericOrgaUnitTab> tabs = new LinkedHashMap<String, GenericOrgaUnitTab>();
        for (String token : tokens) {
            this.processTabConfigToken(tabs, token);
        }
        logger.debug((Object)String.format("Processed tab config in %d ms", System.currentTimeMillis() - start));
        return tabs;
    }

    private void processTabConfigToken(Map<String, GenericOrgaUnitTab> tabs, String tabConfigToken) {
        String[] tokens = tabConfigToken.split(":");
        if (tokens.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid tab configuration token. Found more or less thantwo tokens in string '%s'.", tabConfigToken));
        }
        String tabName = tokens[0];
        String tabClassName = tokens[1];
        GenericOrgaUnitTab tab = this.createTabInstance(tabClassName);
        tabs.put(tabName, tab);
    }

    private GenericOrgaUnitTab createTabInstance(String tabClassName) {
        GenericOrgaUnitTab tab;
        try {
            tab = (GenericOrgaUnitTab)Class.forName(tabClassName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(String.format("Can't find tab class '%s'.", tabClassName), ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(String.format("Can't instantiate tab class '%s'.", tabClassName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(String.format("Can't instantiate tab class '%s'.", tabClassName), ex);
        }
        return tab;
    }

    @Override
    public void addGlobalStateParams(Page page) {
    }

    @Override
    public void setListMode(boolean listMode) {
        this.listMode = listMode;
    }
}

