/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.panels.Paginator;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class GenericOrgaUnitMembersTab
implements GenericOrgaUnitTab {
    private static final Logger logger = Logger.getLogger(GenericOrgaUnitMembersTab.class);

    @Override
    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        return !orgaunit.getPersons().isEmpty();
    }

    @Override
    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        List<GenericPerson> persons = this.getPersons(orgaunit, state);
        Element personsElem = parent.newChildElement(this.getXmlElementName());
        if (this.getPageSize() != 0) {
            Paginator paginator = new Paginator(state.getRequest(), persons.size(), this.getPageSize());
            paginator.generateXml(personsElem);
            if (paginator.getEnd() < persons.size()) {
                persons = persons.subList(paginator.getBegin(), paginator.getEnd());
            }
        }
        for (GenericPerson person : persons) {
            this.generatePersonXml(person, personsElem, state);
        }
        logger.debug((Object)String.format("Generated member list of organizational unit '%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    private void generatePersonXml(BigDecimal personId, Element parent, PageState state) {
        GenericPerson person = new GenericPerson(personId);
        XmlGenerator generator = new XmlGenerator(person);
        generator.setItemElemName("person", "");
        generator.generateXML(state, parent, "");
    }

    private void generatePersonXml(GenericPerson person, Element parent, PageState state) {
        XmlGenerator generator = new XmlGenerator(person);
        generator.generateXML(state, parent, "");
    }

    protected abstract String getXmlElementName();

    protected abstract boolean isMergingMembers();

    protected abstract List<String> getAssocTypesToMerge();

    protected abstract List<String> getRolesToInclude();

    protected abstract List<String> getStatusesToInclude();

    protected abstract int getPageSize();

    protected List<GenericPerson> getPersons(GenericOrganizationalUnit orgaunit, PageState state) {
        long start = System.currentTimeMillis();
        LinkedList<GenericPerson> persons = new LinkedList<GenericPerson>();
        GenericOrganizationalUnitPersonCollection personColl = orgaunit.getPersons();
        if (this.getRolesToInclude() != null && !this.getRolesToInclude().isEmpty()) {
            StringBuffer roleFilter = new StringBuffer();
            for (String role : this.getRolesToInclude()) {
                if (roleFilter.length() > 0) {
                    roleFilter.append(" or ");
                }
                roleFilter.append(String.format("link.roleName = '%s'", role));
            }
            personColl.addFilter(roleFilter.toString());
        }
        if (this.getStatusesToInclude() != null && !this.getStatusesToInclude().isEmpty()) {
            StringBuffer statusFilter = new StringBuffer();
            for (String status : this.getStatusesToInclude()) {
                if (statusFilter.length() > 0) {
                    statusFilter.append(" or ");
                }
                statusFilter.append(String.format("link.status = '%s'", status));
            }
            personColl.addFilter(statusFilter.toString());
        }
        while (personColl.next()) {
            persons.add(personColl.getPerson());
        }
        if (this.isMergingMembers()) {
            this.getPersonsFromSubordinateOrgaUnits(orgaunit, persons, state);
        }
        logger.debug((Object)String.format("Got members of orgaunit '%s'in '%d ms'. MergeMembers is set to '%b'.", orgaunit.getName(), System.currentTimeMillis() - start, this.isMergingMembers()));
        return persons;
    }

    protected void getPersonsFromSubordinateOrgaUnits(GenericOrganizationalUnit orgaunit, List<GenericPerson> persons, PageState state) {
        GenericOrganizationalUnitSubordinateCollection subOrgaUnits = orgaunit.getSubordinateOrgaUnits();
        StringBuffer assocTypeFilter = new StringBuffer();
        for (String assocType : this.getAssocTypesToMerge()) {
            if (assocTypeFilter.length() > 0) {
                assocTypeFilter.append(" or ");
            }
            assocTypeFilter.append(String.format("assocType = '%s'", assocType));
        }
        subOrgaUnits.addFilter(assocTypeFilter.toString());
        while (subOrgaUnits.next()) {
            this.getPersonsFromSubordinateOrgaUnit(orgaunit, persons, state);
        }
    }

    protected void getPersonsFromSubordinateOrgaUnit(GenericOrganizationalUnit subOrgaUnit, List<GenericPerson> persons, PageState state) {
        List<GenericPerson> subOrgaUnitMembers = this.getPersons(subOrgaUnit, state);
        persons.addAll(subOrgaUnitMembers);
    }

    protected void generateFiltersXml(GenericOrganizationalUnit orgaunit, GenericOrganizationalUnitPersonCollection subOrgaUnits, Element element, PageState state) {
    }

    protected void processFilters(GenericOrganizationalUnitPersonCollection subOrgaUnits, PageState state) {
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final GenericPerson person;

        public XmlGenerator(GenericPerson person) {
            this.person = person;
        }

        @Override
        protected ContentItem getContentItem(PageState state) {
            return this.person;
        }
    }
}

