/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;

public class GenericOrgaUnitPaginator<T extends DataQuery> {
    private static final String PAGE_NUMBER = "pageNumber";
    private final long pageSize;
    private final long pageCount;
    private final long begin;
    private final long count;
    private final long end;
    private final long pageNumber;

    public GenericOrgaUnitPaginator(T collection, PageState state, long pageSize) {
        this.pageSize = pageSize;
        long pageNum = this.getPageNumber(state);
        this.pageCount = this.getPageCount(collection.size());
        this.begin = this.getPaginatorBegin(pageNum);
        this.count = this.getPaginatorCount(this.begin, collection.size());
        this.end = this.getPaginatorEnd(this.begin, this.count);
        this.pageNumber = this.normalizePageNumber(this.pageCount, pageNum);
    }

    public void setRange(T collection) {
        collection.setRange(Integer.valueOf((int)this.begin + 1), Integer.valueOf((int)this.end + 1));
    }

    public void generateXml(Element parent) {
        Element paginatorElem = parent.newChildElement("nav:paginator", "http://ccm.redhat.com/navigation");
        URL requestUrl = Web.getContext().getRequestURL();
        ParameterMap parameters = new ParameterMap();
        if (requestUrl.getParameterMap() != null) {
            for (String key : requestUrl.getParameterMap().keySet()) {
                if (PAGE_NUMBER.equals(key)) continue;
                parameters.setParameter(key, (Object)requestUrl.getParameterValues(key));
            }
        }
        paginatorElem.addAttribute("pageParam", PAGE_NUMBER);
        paginatorElem.addAttribute("baseURL", URL.there((String)requestUrl.getPathInfo(), (ParameterMap)parameters).toString());
        paginatorElem.addAttribute(PAGE_NUMBER, Long.toString(this.pageNumber));
        paginatorElem.addAttribute("pageCount", Long.toString(this.pageCount));
        paginatorElem.addAttribute("pageSize", Long.toString(this.pageSize));
        paginatorElem.addAttribute("objectBegin", Long.toString(this.begin + 1L));
        paginatorElem.addAttribute("objectEnd", Long.toString(this.end + 1L));
        paginatorElem.addAttribute("objectCount", Long.toString(this.count));
    }

    private long getPageNumber(PageState state) {
        long num = 1L;
        if (state == null) {
            return num;
        }
        String value = state.getRequest().getParameter(PAGE_NUMBER);
        if (value != null) {
            try {
                num = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                num = 1L;
            }
        }
        return num;
    }

    private long normalizePageNumber(long pageCount, long pageNumber) {
        long num = pageNumber;
        if (num < 1L) {
            num = 1L;
        }
        if (num > pageCount) {
            num = pageCount == 0L ? 1L : pageCount;
        }
        return num;
    }

    private long getPageCount(long objectCount) {
        double dObjectCount = objectCount;
        double dPageSize = this.pageSize;
        double dResult = Math.ceil(dObjectCount / (double)this.pageSize);
        long result = (long)dResult;
        return result;
    }

    private long getPaginatorBegin(long pageNumber) {
        return (pageNumber - 1L) * this.pageSize;
    }

    private long getPaginatorCount(long begin, long objectCount) {
        return Math.min(this.pageSize, objectCount - begin);
    }

    private long getPaginatorEnd(long begin, long count) {
        long paginatorEnd = begin + count;
        if (paginatorEnd < 0L) {
            paginatorEnd = 0L;
        }
        return paginatorEnd;
    }
}

