/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitPaginator;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public abstract class GenericOrgaUnitSubordinateTab
implements GenericOrgaUnitTab {
    private static final Logger logger = Logger.getLogger(GenericOrgaUnitSubordinateTab.class);

    @Override
    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        return !this.getData(orgaunit).isEmpty();
    }

    @Override
    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericOrganizationalUnitSubordinateCollection subOrgaUnits = this.getData(orgaunit, state);
        this.processFilters(subOrgaUnits, state);
        Element subOrgaUnitsElem = parent.newChildElement(this.getXmlElementName());
        if (this.getPageSize() != 0) {
            GenericOrgaUnitPaginator<GenericOrganizationalUnitSubordinateCollection> paginator = new GenericOrgaUnitPaginator<GenericOrganizationalUnitSubordinateCollection>(subOrgaUnits, state, this.getPageSize());
            paginator.setRange(subOrgaUnits);
            paginator.generateXml(subOrgaUnitsElem);
        }
        while (subOrgaUnits.next()) {
            this.generateSubOrgaUnitXml(subOrgaUnits.getGenericOrganizationalUnit(), parent, state);
        }
        logger.debug((Object)String.format("XML for subordinate organizational units of organizational unit '%s' with assoctype '%s' generated in%d ms", orgaunit.getName(), this.getAssocType(), System.currentTimeMillis() - start));
    }

    private void generateSubOrgaUnitXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        XmlLGenerator generator = new XmlLGenerator(orgaunit);
        generator.generateXML(state, parent, "");
    }

    protected GenericOrganizationalUnitSubordinateCollection getData(GenericOrganizationalUnit orgaunit, PageState state) {
        return this.getData(orgaunit);
    }

    protected GenericOrganizationalUnitSubordinateCollection getData(GenericOrganizationalUnit orgaunit) {
        GenericOrganizationalUnitSubordinateCollection subOrgaUnits = orgaunit.getSubordinateOrgaUnits();
        subOrgaUnits.addFilter(String.format("%s = '%s'", "link.assocType", this.getAssocType()));
        return subOrgaUnits;
    }

    protected abstract String getXmlElementName();

    protected abstract String getAssocType();

    protected abstract int getPageSize();

    protected void generateFiltersXml(GenericOrganizationalUnit orgaunit, GenericOrganizationalUnitSubordinateCollection subOrgaUnits, Element element, PageState state) {
    }

    protected void processFilters(GenericOrganizationalUnitSubordinateCollection subOrgaUnits, PageState state) {
    }

    private class XmlLGenerator
    extends SimpleXMLGenerator {
        private final GenericOrganizationalUnit orgaunit;

        public XmlLGenerator(GenericOrganizationalUnit orgaunit) {
            this.orgaunit = orgaunit;
        }

        @Override
        protected ContentItem getContentItem(PageState state) {
            return this.orgaunit;
        }
    }
}

