/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitContactPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.Kernel;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnitContactAddForm
extends BasicItemForm
implements FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(GenericOrganizationalUnitContactAddForm.class);
    private GenericOrganizationalUnitPropertiesStep m_step;
    private ItemSearchWidget m_itemSearch;
    private SaveCancelSection m_saveCancelSection;
    private final String ITEM_SEARCH = "personAddress";
    private ItemSelectionModel m_itemModel;
    private GenericOrganizationalUnitContactPropertiesStep editStep;
    private Label selectedContactLabel;

    public GenericOrganizationalUnitContactAddForm(ItemSelectionModel itemModel, GenericOrganizationalUnitContactPropertiesStep editStep) {
        super("ContactEntryAddForm", itemModel);
        this.m_itemModel = itemModel;
        this.editStep = editStep;
        this.addSubmissionListener(this);
    }

    @Override
    protected void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.select_contact").localize()));
        this.m_itemSearch = new ItemSearchWidget("personAddress", ContentType.findByAssociatedObjectType(GenericContact.class.getName()));
        this.m_itemSearch.setDisableCreatePane(false);
        this.add((Component)this.m_itemSearch);
        this.selectedContactLabel = new Label("");
        this.add((Component)this.selectedContactLabel);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.type")));
        StringParameter contactTypeParam = new StringParameter("contact_type");
        SingleSelect contactType = new SingleSelect((ParameterModel)contactTypeParam);
        contactType.addValidationListener((ParameterListener)new NotNullValidationListener());
        contactType.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        GenericContactTypeCollection contacttypes = new GenericContactTypeCollection();
        contacttypes.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (contacttypes.next()) {
            RelationAttribute ct = contacttypes.getRelationAttribute();
            contactType.addOption(new Option(ct.getKey(), ct.getName()));
        }
        this.add((Component)contactType);
    }

    @Override
    public void init(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericContact selectedContact = this.editStep.getSelectedContact();
        String selectedContactType = this.editStep.getSelectedContactType();
        if (selectedContact == null) {
            this.selectedContactLabel.setVisible(state, false);
        } else {
            data.put((Object)"personAddress", (Object)selectedContact);
            data.put((Object)"contact_type", (Object)selectedContactType);
            this.m_itemSearch.setVisible(state, false);
            this.selectedContactLabel.setLabel(selectedContact.getTitle(), state);
            this.selectedContactLabel.setVisible(state, true);
        }
        this.setVisible(state, true);
    }

    @Override
    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)this.getItemSelectionModel().getSelectedObject(state);
        if (this.getSaveCancelSection().getSaveButton().isSelected(state)) {
            GenericContact selectedContact = this.editStep.getSelectedContact();
            if (selectedContact == null) {
                GenericContact contact = (GenericContact)data.get((Object)"personAddress");
                contact = orgaunit.getLanguage().equals(GlobalizationHelper.LANG_INDEPENDENT) ? (GenericContact)contact.getContentBundle().getPrimaryInstance() : (GenericContact)contact.getContentBundle().getInstance(orgaunit.getLanguage());
                orgaunit.addContact(contact, (String)data.get((Object)"contact_type"));
            } else {
                GenericOrganizationalUnitContactCollection contacts = orgaunit.getContacts();
                while (contacts.next() && !contacts.getContact().equals(selectedContact)) {
                }
                contacts.setContactType((String)data.get((Object)"contact_type"));
                this.editStep.setSelectedContact(null);
                this.editStep.setSelectedContactType(null);
                contacts.close();
            }
        }
        this.init(fse);
    }

    public void submitted(FormSectionEvent fse) throws FormProcessException {
        if (this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.editStep.setSelectedContact(null);
            this.editStep.setSelectedContactType(null);
            this.init(fse);
        }
    }

    @Override
    public void validate(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        if (this.editStep.getSelectedContact() == null && data.get((Object)"personAddress") == null) {
            data.addError("cms.contenttypes.ui.genericorgaunit.select_contact.no_contact_selected");
            return;
        }
        if (this.editStep.getSelectedContact() == null) {
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)this.getItemSelectionModel().getSelectedObject(state);
            GenericContact contact = (GenericContact)data.get((Object)"personAddress");
            if (!orgaunit.getLanguage().equals(GlobalizationHelper.LANG_INDEPENDENT) && !contact.getContentBundle().hasInstance(orgaunit.getLanguage(), Kernel.getConfig().languageIndependentItems())) {
                data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.select_contact.no_suitable_language_variant"));
                return;
            }
            contact = orgaunit.getLanguage().equals(GlobalizationHelper.LANG_INDEPENDENT) ? (GenericContact)contact.getContentBundle().getPrimaryInstance() : (GenericContact)contact.getContentBundle().getInstance(orgaunit.getLanguage());
            GenericOrganizationalUnitContactCollection contacts = orgaunit.getContacts();
            contacts.addFilter(String.format("id = %s", contact.getID().toString()));
            if (contacts.size() > 0L) {
                data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.select_contact.already_added"));
            }
            contacts.close();
        }
    }
}

