/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitContactPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnitContactTable
extends Table
implements TableActionListener {
    private static final Logger s_log = Logger.getLogger(GenericOrganizationalUnitContactTable.class);
    private static final String TABLE_COL_EDIT = "table_col_edit";
    private static final String TABLE_COL_EDIT_ASSOC = "table_col_edit_assoc";
    private static final String TABLE_COL_DEL = "table_col_del";
    private static final String TABLE_COL_UP = "table_col_up";
    private static final String TABLE_COL_DOWN = "table_col_down";
    private ItemSelectionModel m_itemModel;
    private GenericOrganizationalUnitContactPropertiesStep editStep;

    public GenericOrganizationalUnitContactTable(ItemSelectionModel itemModel, GenericOrganizationalUnitContactPropertiesStep editStep) {
        this.m_itemModel = itemModel;
        this.editStep = editStep;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contacts.none")));
        TableColumnModel tabModel = this.getColumnModel();
        tabModel.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.type").localize()));
        tabModel.add(new TableColumn(1, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.title").localize(), (Object)TABLE_COL_EDIT));
        tabModel.add(new TableColumn(2, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.edit").localize(), (Object)TABLE_COL_EDIT_ASSOC));
        tabModel.add(new TableColumn(3, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.action").localize(), (Object)TABLE_COL_DEL));
        tabModel.add(new TableColumn(4, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.up").localize(), (Object)TABLE_COL_UP));
        tabModel.add(new TableColumn(5, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.contact.down").localize(), (Object)TABLE_COL_DOWN));
        this.setModelBuilder(new GenericOrganizationalUnitTableModelBuilder(itemModel));
        tabModel.get(1).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        tabModel.get(2).setCellRenderer((TableCellRenderer)new EditAssocCellRenderer());
        tabModel.get(3).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        tabModel.get(4).setCellRenderer((TableCellRenderer)new UpCellRenderer());
        tabModel.get(5).setCellRenderer((TableCellRenderer)new DownCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent event) {
        PageState state = event.getPageState();
        GenericContact contact = new GenericContact(new BigDecimal(event.getRowKey().toString()));
        GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)this.m_itemModel.getSelectedObject(state);
        GenericOrganizationalUnitContactCollection contacts = orgaunit.getContacts();
        TableColumn column = this.getColumnModel().get(event.getColumn().intValue());
        if (!column.getHeaderKey().toString().equals(TABLE_COL_EDIT)) {
            if (column.getHeaderKey().toString().equals(TABLE_COL_EDIT_ASSOC)) {
                while (contacts.next() && !contacts.getContact().equals(contact)) {
                }
                this.editStep.setSelectedContact(contact);
                this.editStep.setSelectedContactType(contacts.getContactType());
                contacts.close();
                this.editStep.showComponent(state, "addContact");
            } else if (column.getHeaderKey().toString().equals(TABLE_COL_DEL)) {
                orgaunit.removeContact(contact);
            } else if (column.getHeaderKey().toString().equals(TABLE_COL_UP)) {
                contacts.swapWithPrevious(contact);
            } else if (column.getHeaderKey().toString().equals(TABLE_COL_DOWN)) {
                contacts.swapWithNext(contact);
            }
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class DownCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DownCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitContactTable.this.m_itemModel.getSelectedObject(state);
            GenericOrganizationalUnitContactCollection contacts = orgaunit.getContacts();
            if (contacts.size() - 1L == (long)row) {
                s_log.debug((Object)"Row is last row in table, don't show down-link");
                return new Label("");
            }
            ControlLink link = new ControlLink("down");
            return link;
        }
    }

    private class UpCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private UpCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            if (0 == row) {
                s_log.debug((Object)"Row is first row in table, don't show up-link");
                return new Label("");
            }
            ControlLink link = new ControlLink("up");
            return link;
        }
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitContactTable.this.m_itemModel.getSelectedObject(state);
            boolean canDelete = securityManager.canAccess(state.getRequest(), "delete_item", (ContentItem)orgaunit);
            if (canDelete) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.confirm_delete").localize());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class EditAssocCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditAssocCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitContactTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)orgaunit);
            if (canEdit) {
                ControlLink link = new ControlLink(value.toString());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            GenericContact contact;
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitContactTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)orgaunit);
            if (canEdit) {
                GenericContact contact2;
                try {
                    contact2 = new GenericContact((BigDecimal)key);
                }
                catch (DataObjectNotFoundException ex) {
                    return new Label(value.toString());
                }
                ContentSection section = CMS.getContext().getContentSection();
                ItemResolver resolver = section.getItemResolver();
                Link link = new Link(String.format("%s (%s)", value.toString(), contact2.getLanguage()), resolver.generateItemURL(state, contact2, section, contact2.getVersion()));
                return link;
            }
            try {
                contact = new GenericContact((BigDecimal)key);
            }
            catch (DataObjectNotFoundException ex) {
                return new Label(value.toString());
            }
            Label label = new Label(String.format("%s (%s)", value.toString(), contact.getLanguage()));
            return label;
        }
    }

    private class GenericOrganizationalUnitTableModel
    implements TableModel {
        private Table m_table;
        private GenericOrganizationalUnitContactCollection m_contactCollection;
        private GenericContact m_contact;
        private GenericContactTypeCollection m_contacttypes = new GenericContactTypeCollection();

        private GenericOrganizationalUnitTableModel(Table table, PageState state, GenericOrganizationalUnit orgaunit) {
            this.m_table = table;
            this.m_contactCollection = orgaunit.getContacts();
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            boolean ret;
            if (this.m_contactCollection != null && this.m_contactCollection.next()) {
                this.m_contact = this.m_contactCollection.getContact();
                ret = true;
            } else {
                ret = false;
            }
            return ret;
        }

        public Object getElementAt(int columnIndex) {
            s_log.debug((Object)String.format("contacttypes.size() = %d", this.m_contacttypes.size()));
            switch (columnIndex) {
                case 0: {
                    s_log.debug((Object)String.format("Getting human readable contact type for contact type \"%s\"...", this.m_contactCollection.getContactType()));
                    String lang = GlobalizationHelper.getNegotiatedLocale().getLanguage();
                    if (this.m_contacttypes.size() <= 0L) {
                        s_log.warn((Object)String.format("No matching relation attributes for contact type '%s' found. Using key as fallback.", this.m_contactCollection.getContactType()));
                        return this.m_contactCollection.getContactType();
                    }
                    if (this.m_contacttypes.getRelationAttribute(this.m_contactCollection.getContactType(), lang) == null) {
                        s_log.debug((Object)String.format("No human readable name found for '%s' for language '%s' Using key.", this.m_contactCollection.getContactType(), lang));
                        String contactType = this.m_contactCollection.getContactType();
                        this.m_contacttypes.close();
                        return contactType;
                    }
                    s_log.debug((Object)String.format("Human readable contact type is: \"%s\"...", this.m_contacttypes.getRelationAttribute(this.m_contactCollection.getContactType(), GlobalizationHelper.getNegotiatedLocale().getLanguage()).getName()));
                    return this.m_contacttypes.getRelationAttribute(this.m_contactCollection.getContactType(), GlobalizationHelper.getNegotiatedLocale().getLanguage()).getName();
                }
                case 1: {
                    return this.m_contact.getTitle();
                }
                case 2: {
                    return GlobalizationUtil.globalize("cms.ui.edit_assoc").localize();
                }
                case 3: {
                    return GlobalizationUtil.globalize("cms.ui.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_contact.getID();
        }
    }

    private class GenericOrganizationalUnitTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_itemModel;

        public GenericOrganizationalUnitTableModelBuilder(ItemSelectionModel itemModel) {
            this.m_itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)this.m_itemModel.getSelectedObject(state);
            return new GenericOrganizationalUnitTableModel(table, state, orgaunit);
        }
    }
}

