/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.RelationAttributeCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPersonSelector;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.globalization.GlobalizationHelper;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnitPersonAddForm
extends BasicItemForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger logger = Logger.getLogger(GenericOrganizationalUnitPersonAddForm.class);
    private GenericOrganizationalUnitPersonPropertiesStep m_step;
    private ItemSearchWidget m_itemSearch;
    private final String ITEM_SEARCH = "orgaunitPerson";
    private GenericOrganizationalUnitPersonSelector selector;
    private Label selectedPersonNameLabel;

    public GenericOrganizationalUnitPersonAddForm(ItemSelectionModel itemModel, GenericOrganizationalUnitPersonSelector selector) {
        super("PersonAddForm", itemModel);
        this.selector = selector;
        this.addSubmissionListener(this);
    }

    @Override
    protected void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.select_person").localize()));
        this.m_itemSearch = new ItemSearchWidget("orgaunitPerson", ContentType.findByAssociatedObjectType(this.getPersonType()));
        this.m_itemSearch.setDisableCreatePane(false);
        this.add((Component)this.m_itemSearch);
        this.selectedPersonNameLabel = new Label("");
        this.add((Component)this.selectedPersonNameLabel);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.person.role")));
        StringParameter roleParam = new StringParameter("role_name");
        SingleSelect roleSelect = new SingleSelect((ParameterModel)roleParam);
        roleSelect.addValidationListener((ParameterListener)new NotNullValidationListener());
        roleSelect.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        RelationAttributeCollection roles = new RelationAttributeCollection(this.getRoleAttributeName());
        roles.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (roles.next()) {
            RelationAttribute role = roles.getRelationAttribute();
            roleSelect.addOption(new Option(role.getKey(), role.getName()));
        }
        this.add((Component)roleSelect);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.person.status")));
        StringParameter statusModel = new StringParameter("status");
        SingleSelect statusSelect = new SingleSelect((ParameterModel)statusModel);
        statusSelect.addValidationListener((ParameterListener)new NotNullValidationListener());
        statusSelect.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        RelationAttributeCollection statusColl = new RelationAttributeCollection(this.getStatusAttributeName());
        statusColl.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (statusColl.next()) {
            RelationAttribute status = statusColl.getRelationAttribute();
            statusSelect.addOption(new Option(status.getKey(), status.getName()));
        }
        this.add((Component)statusSelect);
    }

    @Override
    public void init(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericPerson person = this.selector.getSelectedPerson();
        String role = this.selector.getSelectedPersonRole();
        String status = this.selector.getSelectedPersonStatus();
        if (person == null) {
            this.m_itemSearch.setVisible(state, true);
            this.selectedPersonNameLabel.setVisible(state, false);
        } else {
            data.put((Object)"orgaunitPerson", (Object)person);
            data.put((Object)"role_name", (Object)role);
            data.put((Object)"status", (Object)status);
            this.m_itemSearch.setVisible(state, false);
            this.selectedPersonNameLabel.setVisible(state, true);
            this.selectedPersonNameLabel.setLabel(person.getFullName(), state);
        }
        this.setVisible(state, true);
    }

    @Override
    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericOrganizationalUnit orga = (GenericOrganizationalUnit)this.getItemSelectionModel().getSelectedObject(state);
        if (this.getSaveCancelSection().getSaveButton().isSelected(state)) {
            GenericPerson person = this.selector.getSelectedPerson();
            if (person == null) {
                GenericPerson personToAdd = (GenericPerson)data.get((Object)"orgaunitPerson");
                logger.debug((Object)String.format("Adding person %s", personToAdd.getFullName()));
                orga.addPerson(personToAdd, (String)data.get((Object)"role_name"), (String)data.get((Object)"status"));
                this.m_itemSearch.publishCreatedItem(data, personToAdd);
            } else {
                GenericOrganizationalUnitPersonCollection persons = orga.getPersons();
                while (persons.next() && !persons.getPerson().equals(person)) {
                }
                persons.setRoleName((String)data.get((Object)"role_name"));
                persons.setStatus((String)data.get((Object)"status"));
                this.selector.setSelectedPerson(null);
                this.selector.setSelectedPersonRole(null);
                this.selector.setSelectedPersonStatus(null);
                persons.close();
            }
        }
        this.init(fse);
    }

    public void submitted(FormSectionEvent fse) throws FormProcessException {
        if (this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.selector.setSelectedPerson(null);
            this.selector.setSelectedPersonRole(null);
            this.selector.setSelectedPersonStatus(null);
            this.init(fse);
        }
    }

    @Override
    public void validate(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        if (this.selector.getSelectedPerson() == null && data.get((Object)"orgaunitPerson") == null) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.person.no_person_selected"));
            return;
        }
        if (this.selector.getSelectedPerson() == null) {
            GenericOrganizationalUnit orga = (GenericOrganizationalUnit)this.getItemSelectionModel().getSelectedObject(state);
            GenericPerson person = (GenericPerson)data.get((Object)"orgaunitPerson");
            ContentBundle bundle = person.getContentBundle();
            GenericOrganizationalUnitPersonCollection persons = orga.getPersons();
            persons.addFilter(String.format("id = %s", bundle.getID().toString()));
            if (persons.size() > 0L) {
                data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.person.already_added"));
            }
            persons.close();
        }
    }

    protected String getPersonType() {
        return GenericPerson.class.getName();
    }

    protected String getRoleAttributeName() {
        return "GenericOrganizationalUnitRole";
    }

    protected String getStatusAttributeName() {
        return "GenericOrganizationalUnitMemberStatus";
    }
}

