/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttributeCollection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPersonSelector;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnitPersonsTable
extends Table
implements TableActionListener {
    private static final Logger s_log = Logger.getLogger(GenericOrganizationalUnitPersonsTable.class);
    private final String TABLE_COL_EDIT = "table_col_edit";
    private final String TABLE_COL_EDIT_LINK = "table_col_edit_link";
    private final String TABLE_COL_DEL = "table_col_del";
    private ItemSelectionModel m_itemModel;
    private GenericOrganizationalUnitPersonSelector personSelector;

    public GenericOrganizationalUnitPersonsTable(ItemSelectionModel itemModel, GenericOrganizationalUnitPersonSelector personSelector) {
        this.m_itemModel = itemModel;
        this.personSelector = personSelector;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.persons.none")));
        TableColumnModel tabModel = this.getColumnModel();
        tabModel.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.persons.name").localize(), (Object)"table_col_edit"));
        tabModel.add(new TableColumn(1, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.persons.role").localize()));
        tabModel.add(new TableColumn(2, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.persons.status").localize()));
        tabModel.add(new TableColumn(3, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorganunit.persons.edit").localize(), (Object)"table_col_edit_link"));
        tabModel.add(new TableColumn(4, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.persons.delete").localize(), (Object)"table_col_del"));
        this.setModelBuilder(new GenericOrganizationalUnitTableModelBuilder(itemModel));
        tabModel.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        tabModel.get(3).setCellRenderer((TableCellRenderer)new EditLinkCellRenderer());
        tabModel.get(4).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent event) {
        s_log.debug((Object)"Cell selected.");
        PageState state = event.getPageState();
        s_log.debug((Object)String.format("RowKey = %s", event.getRowKey().toString()));
        s_log.debug((Object)String.format("Selected column: %d", (int)event.getColumn()));
        GenericPerson person = new GenericPerson(new BigDecimal(event.getRowKey().toString()));
        GenericOrganizationalUnit orga = (GenericOrganizationalUnit)this.m_itemModel.getSelectedObject(state);
        GenericOrganizationalUnitPersonCollection persons = orga.getPersons();
        TableColumn col = this.getColumnModel().get(event.getColumn().intValue());
        if (!"table_col_edit".equals(col.getHeaderKey().toString())) {
            if ("table_col_edit_link".equals(col.getHeaderKey().toString())) {
                while (persons.next() && !persons.getPerson().equals(person)) {
                }
                this.personSelector.setSelectedPerson(person);
                this.personSelector.setSelectedPersonRole(persons.getRoleName());
                this.personSelector.setSelectedPersonStatus(persons.getStatus());
                persons.close();
                this.personSelector.showEditComponent(state);
            } else if ("table_col_del".equals(col.getHeaderKey().toString())) {
                s_log.debug((Object)"Removing person assoc...");
                orga.removePerson(person);
            }
        }
    }

    public void headSelected(TableActionEvent event) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String getRoleAttributeName() {
        return "GenericOrganizationalUnitRole";
    }

    protected String getStatusAttributeName() {
        return "GenericOrganizationalUnitMemberStatus";
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitPersonsTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "delete_item", (ContentItem)orgaunit);
            if (canEdit) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.genericorgaunit.persons.confirm_delete").localize());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class EditLinkCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditLinkCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericOrganizationalUnit orgaUnit = (GenericOrganizationalUnit)GenericOrganizationalUnitPersonsTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)orgaUnit);
            if (canEdit) {
                ControlLink link = new ControlLink(value.toString());
                return link;
            }
            Label label = new Label(value.toString());
            return label;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            GenericPerson person;
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitPersonsTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)orgaunit);
            if (canEdit) {
                GenericPerson person2;
                try {
                    person2 = new GenericPerson((BigDecimal)key);
                }
                catch (DataObjectNotFoundException ex) {
                    s_log.warn((Object)String.format("No object with key '%s' found.", key), (Throwable)ex);
                    return new Label(value.toString());
                }
                ContentSection section = CMS.getContext().getContentSection();
                ItemResolver resolver = section.getItemResolver();
                Link link = new Link(String.format("%s", value.toString()), resolver.generateItemURL(state, person2, section, person2.getVersion()));
                return link;
            }
            try {
                person = new GenericPerson((BigDecimal)key);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.warn((Object)String.format("No object with key '%s' found.", key), (Throwable)ex);
                return new Label(value.toString());
            }
            Label label = new Label(String.format("%s", value.toString(), person.getLanguage()));
            return label;
        }
    }

    private class GenericOrganizationalUnitTableModel
    implements TableModel {
        private Table m_table;
        private GenericOrganizationalUnitPersonCollection m_personsCollection;
        private GenericPerson m_person;

        private GenericOrganizationalUnitTableModel(Table table, PageState state, GenericOrganizationalUnit orgaunit) {
            this.m_table = table;
            this.m_personsCollection = orgaunit.getPersons();
            s_log.debug((Object)String.format("m_personsCollection.size() = %d", this.m_personsCollection.size()));
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            boolean ret;
            if (this.m_personsCollection != null && this.m_personsCollection.next()) {
                this.m_person = this.m_personsCollection.getPerson();
                ret = true;
            } else {
                ret = false;
            }
            return ret;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_person.getFullName();
                }
                case 1: {
                    RelationAttributeCollection role = new RelationAttributeCollection(GenericOrganizationalUnitPersonsTable.this.getRoleAttributeName(), this.m_personsCollection.getRoleName());
                    if (role.next()) {
                        String roleName = role.getName();
                        role.close();
                        return roleName;
                    }
                    return ContenttypesGlobalizationUtil.globalize("cms.ui.unknownRole").localize();
                }
                case 2: {
                    RelationAttributeCollection status = new RelationAttributeCollection(GenericOrganizationalUnitPersonsTable.this.getStatusAttributeName(), this.m_personsCollection.getStatus());
                    if (status.next()) {
                        String statusName = status.getName();
                        status.close();
                        return statusName;
                    }
                    return ContenttypesGlobalizationUtil.globalize("cms.ui.unknownStatus").localize();
                }
                case 3: {
                    return ContenttypesGlobalizationUtil.globalize("cms.ui.edit_assoc").localize();
                }
                case 4: {
                    return ContenttypesGlobalizationUtil.globalize("cms.ui.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_person.getID();
        }
    }

    private class GenericOrganizationalUnitTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_itemModel;

        public GenericOrganizationalUnitTableModelBuilder(ItemSelectionModel itemModel) {
            this.m_itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)this.m_itemModel.getSelectedObject(state);
            return new GenericOrganizationalUnitTableModel(table, state, orgaunit);
        }
    }
}

