/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GenericOrganizationalUnitSubordinateOrgaUnitsTable
extends Table {
    private final Logger logger = Logger.getLogger(GenericOrganizationalUnitSubordinateOrgaUnitsTable.class);
    private final String TABLE_COL_EDIT = "table_col_edit";
    private final String TABLE_COL_DEL = "table_col_del";
    private final String TABLE_COL_UP = "table_col_up";
    private final String TABLE_COL_DOWN = "table_col_down";
    private final ItemSelectionModel itemModel;
    private final GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer customizer;

    public GenericOrganizationalUnitSubordinateOrgaUnitsTable(ItemSelectionModel itemModel, GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer customizer) {
        this.itemModel = itemModel;
        this.customizer = customizer;
        this.setEmptyView((Component)new Label(customizer.getEmptyViewLabel()));
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.add(new TableColumn(0, (Object)customizer.getNameColumnLabel(), (Object)"table_col_edit"));
        columnModel.add(new TableColumn(1, (Object)customizer.getDeleteColumnLabel(), (Object)"table_col_del"));
        columnModel.add(new TableColumn(2, (Object)customizer.getUpColumnLabel(), (Object)"table_col_up"));
        columnModel.add(new TableColumn(3, (Object)customizer.getDownColumnLabel(), (Object)"table_col_down"));
        this.setModelBuilder(new ModelBuilder(itemModel, customizer));
        columnModel.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        columnModel.get(1).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        columnModel.get(2).setCellRenderer((TableCellRenderer)new UpCellRenderer());
        columnModel.get(3).setCellRenderer((TableCellRenderer)new DownCellRenderer());
        this.addTableActionListener(new ActionListener());
    }

    private class ActionListener
    implements TableActionListener {
        private ActionListener() {
        }

        public void cellSelected(TableActionEvent event) {
            PageState state = event.getPageState();
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.itemModel.getSelectedObject(state);
            GenericOrganizationalUnit subOrgaUnit = new GenericOrganizationalUnit(new BigDecimal((String)event.getRowKey()));
            GenericOrganizationalUnitSubordinateCollection subOrgaUnits = orgaunit.getSubordinateOrgaUnits();
            TableColumn column = GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.getColumnModel().get(event.getColumn().intValue());
            String headerKey = column.getHeaderKey().toString();
            if (!"table_col_edit".equals(headerKey)) {
                if ("table_col_del".equals(headerKey)) {
                    orgaunit.removeSubordinateOrgaUnit(subOrgaUnit);
                } else if ("table_col_up".equals(headerKey)) {
                    subOrgaUnits.swapWithPrevious(subOrgaUnit);
                } else if ("table_col_down".equals(headerKey)) {
                    subOrgaUnits.swapWithNext(subOrgaUnit);
                }
            }
        }

        public void headSelected(TableActionEvent e) {
        }
    }

    private class DownCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DownCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.itemModel.getSelectedObject(state);
            GenericOrganizationalUnitSubordinateCollection subOrgaUnits = orgaunit.getSubordinateOrgaUnits();
            if (GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getAssocType() != null && !GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getAssocType().isEmpty()) {
                subOrgaUnits.addFilter(String.format("link.assocType = '%s'", GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getAssocType()));
            }
            if (GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getContentType() != null && !GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getContentType().isEmpty()) {
                subOrgaUnits.addFilter(String.format("objectType = '%s'", GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getContentType()));
            }
            if (subOrgaUnits.size() - 1L == (long)row) {
                Label label = new Label("");
                return label;
            }
            ControlLink link = new ControlLink(GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getDownLabel());
            return link;
        }
    }

    private class UpCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private UpCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (row == 0) {
                Label label = new Label("");
                return label;
            }
            ControlLink link = new ControlLink(GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getUpLabel());
            return link;
        }
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager securityManager = CMS.getSecurityManager(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.itemModel.getSelectedObject(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)orgaunit);
            if (canEdit) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation(GenericOrganizationalUnitSubordinateOrgaUnitsTable.this.customizer.getConfirmRemoveLabel());
                return link;
            }
            Label label = new Label("");
            return label;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager securityManager = CMS.getSecurityManager(state);
            GenericOrganizationalUnit subordinateOrgaUnit = new GenericOrganizationalUnit((BigDecimal)key);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)subordinateOrgaUnit);
            if (canEdit) {
                ContentSection section = CMS.getContext().getContentSection();
                ItemResolver resolver = section.getItemResolver();
                Link link = new Link(value.toString(), resolver.generateItemURL(state, subordinateOrgaUnit, section, subordinateOrgaUnit.getVersion()));
                return link;
            }
            Label label = new Label(value.toString());
            return label;
        }
    }

    private class Model
    implements TableModel {
        private final Table table;
        private final GenericOrganizationalUnitSubordinateCollection subordinateOrgaUnits;
        private final GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer customizer;

        public Model(Table table, PageState state, GenericOrganizationalUnit orgaunit, GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer customizer) {
            this.table = table;
            this.subordinateOrgaUnits = orgaunit.getSubordinateOrgaUnits();
            if (customizer.getAssocType() != null && !customizer.getAssocType().isEmpty()) {
                this.subordinateOrgaUnits.addFilter(String.format("link.assocType = '%s'", customizer.getAssocType()));
            }
            if (customizer.getContentType() != null && !customizer.getContentType().isEmpty()) {
                this.subordinateOrgaUnits.addFilter(String.format("objectType = '%s'", customizer.getContentType()));
            }
            this.customizer = customizer;
        }

        public int getColumnCount() {
            return this.table.getColumnModel().size();
        }

        public boolean nextRow() {
            boolean ret = this.subordinateOrgaUnits != null && this.subordinateOrgaUnits.next();
            return ret;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.subordinateOrgaUnits.getGenericOrganizationalUnit(GlobalizationHelper.getNegotiatedLocale().getLanguage()).getTitle();
                }
                case 1: {
                    return this.customizer.getDeleteLabel();
                }
                case 2: {
                    return this.customizer.getUpLabel();
                }
                case 3: {
                    return this.customizer.getDownLabel();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.subordinateOrgaUnits.getGenericOrganizationalUnit(GlobalizationHelper.getNegotiatedLocale().getLanguage()).getID();
        }
    }

    private class ModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private final ItemSelectionModel itemModel;
        private final GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer customizer;

        public ModelBuilder(ItemSelectionModel itemModel, GenericOrgaUnitSubordinateOrgaUnitsTableCustomizer customizer) {
            this.itemModel = itemModel;
            this.customizer = customizer;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)this.itemModel.getSelectedObject(state);
            return new Model(table, state, orgaunit, this.customizer);
        }
    }
}

