/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericPersonAliasDeleteForm;
import com.arsdigita.cms.contenttypes.ui.GenericPersonAliasSetForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;

public class GenericPersonAliasPropertiesStep
extends SimpleEditStep {
    public static final String SET_ALIAS_SHEET_NAME = "setAlias";
    public static final String CHANGE_ALIAS_SHEET_NAME = "changeAlias";
    public static final String DELETE_ALIAS_SHEET_NAME = "deleteAlias";
    private final ItemSelectionModel itemModel;

    public GenericPersonAliasPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this(itemModel, parent, "");
    }

    public GenericPersonAliasPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent, String prefix) {
        super(itemModel, parent, prefix);
        this.itemModel = itemModel;
        GenericPersonAliasSetForm setAliasSheet = new GenericPersonAliasSetForm(itemModel, this);
        GenericPersonAliasDeleteForm deleteAliasSheet = new GenericPersonAliasDeleteForm(itemModel, this);
        this.add(SET_ALIAS_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.set_alias").localize(), new GenericPersonAliasSetWorkflowLockedComponentAccess((Component)setAliasSheet, itemModel), setAliasSheet.getSaveCancelSection().getCancelButton());
        this.add(DELETE_ALIAS_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.delete_alias").localize(), new GenericPersonAliasEditWorkflowLockedComponentAccess((Component)deleteAliasSheet, itemModel), deleteAliasSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(GenericPersonAliasPropertiesStep.getAliasPropertySheet(itemModel));
    }

    public static Component getAliasPropertySheet(final ItemSelectionModel itemModel) {
        Label label = new Label(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                GenericPerson person = (GenericPerson)itemModel.getSelectedObject(state);
                GenericPerson alias = person.getAlias();
                if (alias == null) {
                    ((Label)event.getTarget()).setLabel(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.alias.none"));
                } else {
                    ((Label)event.getTarget()).setLabel(alias.getFullName());
                }
            }
        });
        return label;
    }

    public static Component getEmptyAliasPropertySheet(ItemSelectionModel itemModel) {
        return new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.alias.none").localize());
    }

    private class GenericPersonAliasEditWorkflowLockedComponentAccess
    extends WorkflowLockedComponentAccess {
        public GenericPersonAliasEditWorkflowLockedComponentAccess(Component component, ItemSelectionModel itemModel) {
            super(component, itemModel);
        }

        @Override
        public boolean isVisible(PageState state) {
            GenericPerson person = (GenericPerson)GenericPersonAliasPropertiesStep.this.itemModel.getSelectedObject(state);
            return person.getAlias() != null;
        }
    }

    private class GenericPersonAliasSetWorkflowLockedComponentAccess
    extends WorkflowLockedComponentAccess {
        public GenericPersonAliasSetWorkflowLockedComponentAccess(Component component, ItemSelectionModel itemModel) {
            super(component, itemModel);
        }

        @Override
        public boolean isVisible(PageState state) {
            GenericPerson person = (GenericPerson)GenericPersonAliasPropertiesStep.this.itemModel.getSelectedObject(state);
            return person.getAlias() == null;
        }
    }
}

