/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericPersonAliasPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.UncheckedWrapperException;

public class GenericPersonAliasSetForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener {
    private ItemSearchWidget itemSearch;
    private SaveCancelSection saveCancelSection;
    private final String ITEM_SEARCH = "personAlias";
    public static final String ID = "GenericPersonAliasSetForm";

    public GenericPersonAliasSetForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericPersonAliasSetForm(ItemSelectionModel itemModel, GenericPersonAliasPropertiesStep step) {
        super(ID, itemModel);
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    @Override
    public void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.alias.select").localize()));
        this.itemSearch = new ItemSearchWidget("personAlias", ContentType.findByAssociatedObjectType("com.arsdigita.cms.contenttypes.GenericPerson"));
        this.itemSearch.setEditAfterCreate(false);
        this.add((Component)this.itemSearch);
    }

    @Override
    public void init(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericPerson person = (GenericPerson)this.getItemSelectionModel().getSelectedObject(state);
        this.setVisible(state, true);
        if (person != null) {
            data.put((Object)"personAlias", (Object)person.getAlias());
        }
    }

    @Override
    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericPerson person = (GenericPerson)this.getItemSelectionModel().getSelectedObject(state);
        if (this.getSaveCancelSection().getSaveButton().isSelected(state)) {
            GenericPerson alias = (GenericPerson)data.get((Object)"personAlias");
            alias = (GenericPerson)alias.getContentBundle().getInstance(person.getLanguage());
            person.setAlias(alias);
            this.itemSearch.publishCreatedItem(data, alias);
        }
        this.init(fse);
    }

    @Override
    public void addSaveCancelSection() {
        try {
            this.getSaveCancelSection().getSaveButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent event) {
                    GenericPerson person = (GenericPerson)GenericPersonAliasSetForm.this.getItemSelectionModel().getSelectedObject(event.getPageState());
                    Submit target = (Submit)event.getTarget();
                    if (person.getAlias() != null) {
                        target.setButtonLabel((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.alias.select.change").localize());
                    } else {
                        target.setButtonLabel((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.contact.alias.select.add").localize());
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new UncheckedWrapperException("this cannot happen", (Throwable)ex);
        }
    }

    @Override
    public void validate(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        GenericPerson person = (GenericPerson)this.getItemSelectionModel().getSelectedObject(state);
        GenericPerson alias = (GenericPerson)data.get((Object)"personAlias");
        if (data.get((Object)"personAlias") == null) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.person.alias.select.wrong_type"));
        } else if (person.equals(data.get((Object)"personAlias"))) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.person.alias.select.same_as_person"));
        } else if (!alias.getContentBundle().hasInstance(person.getLanguage(), Kernel.getConfig().languageIndependentItems())) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.person.alias.select.no_suitable_language_variant"));
        }
    }
}

