/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonContactCollection;
import com.arsdigita.cms.contenttypes.ui.GenericPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.Kernel;
import org.apache.log4j.Logger;

public class GenericPersonContactAddForm
extends BasicItemForm {
    private static final Logger s_log = Logger.getLogger(GenericPersonContactAddForm.class);
    private GenericPersonPropertiesStep m_step;
    private ItemSearchWidget m_itemSearch;
    private SaveCancelSection m_saveCancelSection;
    private final String ITEM_SEARCH = "personAddress";
    private ItemSelectionModel m_itemModel;

    public GenericPersonContactAddForm(ItemSelectionModel itemModel) {
        super("ContactEntryAddForm", itemModel);
        this.m_itemModel = itemModel;
    }

    @Override
    protected void addWidgets() {
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.select_contact").localize()));
        this.m_itemSearch = new ItemSearchWidget("personAddress", ContentType.findByAssociatedObjectType("com.arsdigita.cms.contenttypes.GenericContact"));
        this.add((Component)this.m_itemSearch);
        this.add((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contact.type")));
        StringParameter contactTypeParam = new StringParameter("link.linkKey");
        SingleSelect contactType = new SingleSelect((ParameterModel)contactTypeParam);
        contactType.addValidationListener((ParameterListener)new NotNullValidationListener());
        contactType.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        GenericContactTypeCollection contacttypes = new GenericContactTypeCollection();
        contacttypes.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        while (contacttypes.next()) {
            RelationAttribute ct = contacttypes.getRelationAttribute();
            contactType.addOption(new Option(ct.getKey(), ct.getName()));
        }
        this.add((Component)contactType);
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        this.setVisible(state, true);
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        GenericPerson person = (GenericPerson)this.getItemSelectionModel().getSelectedObject(state);
        if (!this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            GenericContact contact = (GenericContact)data.get((Object)"personAddress");
            contact = (GenericContact)contact.getContentBundle().getInstance(person.getLanguage());
            person.addContact(contact, (String)data.get((Object)"link.linkKey"));
            this.m_itemSearch.publishCreatedItem(data, contact);
        }
        this.init(fse);
    }

    @Override
    public void validate(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        if (data.get((Object)"personAddress") == null) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.select_contact.no_contact_selected"));
            return;
        }
        GenericPerson person = (GenericPerson)this.getItemSelectionModel().getSelectedObject(state);
        GenericContact contact = (GenericContact)data.get((Object)"personAddress");
        if (!contact.getContentBundle().hasInstance(person.getLanguage(), Kernel.getConfig().languageIndependentItems())) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.select_contact.no_suitable_language_variant"));
            return;
        }
        contact = (GenericContact)contact.getContentBundle().getInstance(person.getLanguage());
        GenericPersonContactCollection contacts = person.getContacts();
        contacts.addFilter(String.format("id = %s", contact.getID().toString()));
        if (contacts.size() > 0L) {
            data.addError(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.select_contact.already_added"));
        }
        contacts.close();
    }
}

